/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.Core;
import arc.func.Cons;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Rules;
import mindustry.gen.Icon;
import mindustry.maps.generators.FileMapGenerator;
import mindustry.mod.Mods;
import mindustry.type.Planet;
import mindustry.type.Sector;

public class SectorPreset
extends UnlockableContent {
    public FileMapGenerator generator;
    public Planet planet;
    public Sector sector;
    public int captureWave = 0;
    public Cons<Rules> rules = rules -> {
        rules.winWave = this.captureWave;
    };
    public float difficulty;
    public float startWaveTimeMultiplier = 2.0f;
    public boolean addStartingItems = false;
    public boolean noLighting = false;
    public boolean isLastSector;
    public boolean requireUnlock = true;
    public boolean showHidden = false;
    public boolean showSectorLandInfo = true;
    public boolean overrideLaunchDefaults = false;
    public boolean allowLaunchSchematics = false;
    public boolean allowLaunchLoadout = false;
    public boolean attackAfterWaves = false;
    public int originalPosition;
    public Seq<Sector> shieldSectors = new Seq();
    @Nullable
    private String fileName;

    public SectorPreset(String name, Planet planet, int sector) {
        this(name, null, planet, sector);
    }

    public SectorPreset(String name, String fileName, Planet planet, int sector) {
        this(name, fileName, null);
        this.initialize(planet, sector);
    }

    public SectorPreset(String name, Mods.LoadedMod mod) {
        this(name, null, mod);
    }

    public SectorPreset(String name, @Nullable String fileName, Mods.LoadedMod mod) {
        super(name);
        if (mod != null) {
            this.minfo.mod = mod;
        }
        this.fileName = fileName;
    }

    public void initialize(Planet planet, int sector) {
        this.planet = planet;
        if (this.generator == null) {
            this.generator = new FileMapGenerator(this.fileName == null ? this.name : this.fileName, this);
        }
        this.originalPosition = sector;
        Planet.PlanetData data = planet.getData();
        if (data != null) {
            sector = data.presets.get(this.name, sector);
        }
        this.sector = planet.sectors.get((sector %= planet.sectors.size) == -1 ? 0 : sector);
        if (sector != -1) {
            planet.preset(sector, this);
        } else {
            Log.warn("Preset '@' doesn't have a sector assigned.", this.name);
        }
    }

    @Override
    public void init() {
        super.init();
        for (Sector other : this.shieldSectors) {
            other.shieldTarget = this.sector;
        }
    }

    @Override
    public void loadIcon() {
        if (Icon.terrain != null) {
            this.uiIcon = this.fullIcon = Core.atlas.find("sector-" + this.name, Icon.terrain.getRegion());
        }
    }

    @Override
    public boolean isHidden() {
        return this.description == null;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.sector;
    }
}

