/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type.weapons;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.world.blocks.units.RepairTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class RepairBeamWeapon
extends Weapon {
    public boolean targetBuildings = false;
    public boolean targetUnits = true;
    public float repairSpeed = 0.3f;
    public float fractionRepairSpeed = 0.0f;
    public float beamWidth = 1.0f;
    public float pulseRadius = 6.0f;
    public float pulseStroke = 2.0f;
    public float widthSinMag = 0.0f;
    public float widthSinScl = 4.0f;
    public float recentDamageMultiplier = 0.1f;
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public TextureRegion laserTop;
    public TextureRegion laserTopEnd;
    public Color laserColor = Color.valueOf("98ffa9");
    public Color laserTopColor = Color.white.cpy();
    public Color healColor = Pal.heal;
    public Effect healEffect = Fx.healBlockFull;

    public RepairBeamWeapon(String name) {
        super(name);
        this.reload = 1.0f;
        this.predictTarget = false;
        this.autoTarget = true;
        this.controllable = false;
        this.rotate = true;
        this.useAmmo = false;
        this.mountType = HealBeamMount::new;
        this.recoil = 0.0f;
        this.noAttack = true;
        this.useAttackRange = false;
        this.activeSound = Sounds.beamHeal;
    }

    public RepairBeamWeapon() {
        this.reload = 1.0f;
        this.predictTarget = false;
        this.autoTarget = true;
        this.controllable = false;
        this.rotate = true;
        this.useAmmo = false;
        this.mountType = HealBeamMount::new;
        this.recoil = 0.0f;
        this.noAttack = true;
        this.useAttackRange = false;
        this.activeSound = Sounds.beamHeal;
    }

    @Override
    public void addStats(UnitType u, Table w) {
        w.row();
        w.add("[lightgray]" + Stat.repairSpeed.localized() + ": " + (this.mirror ? "2x " : "") + "[white]" + (int)(this.repairSpeed * 60.0f) + " " + StatUnit.perSecond.localized());
    }

    @Override
    public float dps() {
        return 0.0f;
    }

    @Override
    public void load() {
        super.load();
        this.laser = Core.atlas.find("laser-white");
        this.laserEnd = Core.atlas.find("laser-white-end");
        this.laserTop = Core.atlas.find("laser-top");
        this.laserTopEnd = Core.atlas.find("laser-top-end");
    }

    @Override
    protected Teamc findTarget(Unit unit, float x, float y, float range, boolean air, boolean ground) {
        Unit out;
        Unit unit2 = out = this.targetUnits ? Units.closest(unit.team, x, y, range, u -> u != unit && u.damaged()) : null;
        if (out != null || !this.targetBuildings) {
            return out;
        }
        return Units.findAllyTile(unit.team, x, y, range, Building::damaged);
    }

    @Override
    protected boolean checkTarget(Unit unit, Teamc target, float x, float y, float range) {
        Healthc u;
        return !(target.within(unit, range + unit.hitSize / 2.0f) && target.team() == unit.team && target instanceof Healthc && (u = (Healthc)((Object)target)).damaged() && u.isValid());
    }

    @Override
    protected void shoot(Unit unit, WeaponMount mount, float shootX, float shootY, float rotation) {
    }

    @Override
    public void update(Unit unit, WeaponMount mount) {
        Building b;
        Teamc teamc;
        super.update(unit, mount);
        float weaponRotation = unit.rotation - 90.0f;
        float wx = unit.x + Angles.trnsx(weaponRotation, this.x, this.y);
        float wy = unit.y + Angles.trnsy(weaponRotation, this.x, this.y);
        HealBeamMount heal = (HealBeamMount)mount;
        boolean canShoot = mount.shoot;
        if (!this.autoTarget) {
            heal.target = null;
            if (canShoot) {
                heal.lastEnd.set(heal.aimX, heal.aimY);
                if (!this.rotate && !Angles.within(Angles.angle(wx, wy, heal.aimX, heal.aimY), unit.rotation, this.shootCone)) {
                    canShoot = false;
                }
            }
            heal.lastEnd.sub(wx, wy).limit(this.range()).add(wx, wy);
            if (this.targetBuildings) {
                World.raycastEachWorld(wx, wy, heal.lastEnd.x, heal.lastEnd.y, (x, y) -> {
                    Building build = Vars.world.build(x, y);
                    if (build != null && build.team == unit.team && build.damaged()) {
                        heal.target = build;
                        heal.lastEnd.set(x * 8, y * 8);
                        return true;
                    }
                    return false;
                });
            }
            if (this.targetUnits) {
                // empty if block
            }
        }
        heal.strength = Mathf.lerpDelta(heal.strength, Mathf.num(this.autoTarget ? mount.target != null : canShoot), 0.2f);
        if (canShoot && (teamc = mount.target) instanceof Building && (b = (Building)teamc).damaged()) {
            float f;
            heal.effectTimer += Time.delta;
            if (f >= this.reload) {
                this.healEffect.at(b.x, b.y, 0.0f, this.healColor, b.block);
                heal.effectTimer = 0.0f;
            }
        }
        if (canShoot && (teamc = mount.target) instanceof Healthc) {
            Building b2;
            Healthc u = (Healthc)((Object)teamc);
            float baseAmount = this.repairSpeed * heal.strength * Time.delta + this.fractionRepairSpeed * heal.strength * Time.delta * u.maxHealth() / 100.0f;
            u.heal((u instanceof Building && (b2 = (Building)u).wasRecentlyDamaged() ? this.recentDamageMultiplier : 1.0f) * baseAmount);
        }
    }

    @Override
    public void draw(Unit unit, WeaponMount mount) {
        super.draw(unit, mount);
        HealBeamMount heal = (HealBeamMount)mount;
        if (unit.canShoot()) {
            float weaponRotation = unit.rotation - 90.0f;
            float wx = unit.x + Angles.trnsx(weaponRotation, this.x, this.y);
            float wy = unit.y + Angles.trnsy(weaponRotation, this.x, this.y);
            float z = Draw.z();
            RepairTurret.drawBeam(wx, wy, unit.rotation + mount.rotation, this.shootY, unit.id, mount.target == null || this.controllable ? null : (Sized)((Object)mount.target), unit.team, heal.strength, this.pulseStroke, this.pulseRadius, this.beamWidth + Mathf.absin(this.widthSinScl, this.widthSinMag), heal.lastEnd, heal.offset, this.laserColor, this.laserTopColor, this.laser, this.laserEnd, this.laserTop, this.laserTopEnd);
            Draw.z(z);
        }
    }

    @Override
    public void init() {
        super.init();
        this.bullet.healPercent = this.fractionRepairSpeed;
    }

    public static class HealBeamMount
    extends WeaponMount {
        public Vec2 offset = new Vec2();
        public Vec2 lastEnd = new Vec2();
        public float strength;
        public float effectTimer;

        public HealBeamMount(Weapon weapon) {
            super(weapon);
        }
    }
}

