/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.func.Floatp;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.input.KeyCode;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.WarningBar;

public class LoadingFragment {
    private Table table;
    private TextButton button;
    private Bar bar;
    private Label nameLabel;
    @Nullable
    private Runnable cancelListener;
    private float progValue;

    public void build(Group parent) {
        parent.fill(t -> {
            t.rect((x, y, w, h) -> {
                Draw.alpha(t.color.a);
                Styles.black8.draw(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
            });
            t.visible = false;
            t.touchable = Touchable.enabled;
            t.add().height(133.0f).row();
            t.add(new WarningBar()).growX().height(24.0f);
            t.row();
            this.nameLabel = t.add("@loading").pad(10.0f).style(Styles.techLabel).get();
            t.row();
            t.add(new WarningBar()).growX().height(24.0f);
            t.row();
            this.text("@loading");
            this.bar = t.add(new Bar()).pad(3.0f).padTop(6.0f).size(500.0f, 40.0f).visible(false).get();
            t.row();
            this.button = t.button("@cancel", () -> {
                if (this.cancelListener != null) {
                    this.cancelListener.run();
                }
            }).pad(20.0f).size(250.0f, 70.0f).visible(false).get();
            this.button.keyDown(key -> {
                if (this.cancelListener != null && (key == KeyCode.back || key == KeyCode.escape)) {
                    this.cancelListener.run();
                }
            });
            this.table = t;
        });
    }

    public void toFront() {
        this.table.toFront();
    }

    public void setProgress(Floatp progress) {
        this.bar.reset(0.0f);
        this.bar.visible = true;
        this.bar.set(() -> (int)(progress.get() * 100.0f) + "%", progress, Pal.accent);
    }

    public void snapProgress() {
        this.bar.snap();
    }

    public void setProgress(float progress) {
        this.progValue = progress;
        if (!this.bar.visible) {
            this.setProgress(() -> this.progValue);
        }
    }

    public void setButton(Runnable listener) {
        this.button.visible = true;
        this.button.requestKeyboard();
        this.cancelListener = listener;
    }

    public void setText(String text) {
        this.text(text);
        this.nameLabel.setColor(Pal.accent);
    }

    public void show() {
        this.show("@loading");
    }

    public void show(String text) {
        this.button.visible = false;
        this.cancelListener = null;
        this.nameLabel.setColor(Color.white);
        this.bar.visible = false;
        this.table.clearActions();
        this.table.touchable = Touchable.enabled;
        this.text(text);
        this.table.visible = true;
        this.table.color.a = 1.0f;
        this.table.toFront();
    }

    public void hide() {
        this.table.clearActions();
        this.table.toFront();
        this.button.visible = false;
        this.table.touchable = Touchable.disabled;
        this.table.actions(Actions.fadeOut(0.5f), Actions.visible(false));
        if (Core.scene.getKeyboardFocus() == this.button) {
            Core.scene.setKeyboardFocus(null);
        }
    }

    private void text(String text) {
        this.nameLabel.setText(text);
        StringBuilder realText = this.nameLabel.getText();
        for (int i = 0; i < realText.length(); ++i) {
            if (Fonts.tech.getData().getGlyph(realText.charAt(i)) != null) continue;
            this.nameLabel.setStyle(Styles.defaultLabel);
            return;
        }
        this.nameLabel.setStyle(Styles.techLabel);
    }
}

