/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks;

import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Tmp;
import java.util.Arrays;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;

public interface Autotiler {
    default public TextureRegion sliced(TextureRegion input, SliceMode mode) {
        return mode == SliceMode.none ? input : (mode == SliceMode.bottom ? this.botHalf(input) : this.topHalf(input));
    }

    default public TextureRegion topHalf(TextureRegion input) {
        TextureRegion region = Tmp.tr1;
        region.set(input);
        region.setWidth(region.width / 2);
        return region;
    }

    default public TextureRegion botHalf(TextureRegion input) {
        TextureRegion region = Tmp.tr1;
        region.set(input);
        int width = region.width;
        region.setWidth(width / 2);
        region.setX(region.getX() + width);
        return region;
    }

    @Nullable
    default public int[] getTiling(BuildPlan req, Eachable<BuildPlan> list) {
        if (req.tile() == null) {
            return null;
        }
        Object[] directionals = AutotilerHolder.directionals;
        Arrays.fill(directionals, null);
        list.each(arg_0 -> Autotiler.lambda$getTiling$0(req, (BuildPlan[])directionals, arg_0));
        return this.buildBlending(req.tile(), req.rotation, (BuildPlan[])directionals, req.worldContext);
    }

    default public int[] buildBlending(Tile tile, int rotation, BuildPlan[] directional, boolean world) {
        int i;
        int[] blendresult = AutotilerHolder.blendresult;
        blendresult[0] = 0;
        blendresult[2] = 1;
        blendresult[1] = 1;
        int num = this.blends(tile, rotation, directional, 2, world) && this.blends(tile, rotation, directional, 1, world) && this.blends(tile, rotation, directional, 3, world) ? 0 : (this.blends(tile, rotation, directional, 1, world) && this.blends(tile, rotation, directional, 3, world) ? 1 : (this.blends(tile, rotation, directional, 1, world) && this.blends(tile, rotation, directional, 2, world) ? 2 : (this.blends(tile, rotation, directional, 3, world) && this.blends(tile, rotation, directional, 2, world) ? 3 : (this.blends(tile, rotation, directional, 1, world) ? 4 : (this.blends(tile, rotation, directional, 3, world) ? 5 : -1)))));
        this.transformCase(num, blendresult);
        blendresult[3] = 0;
        for (i = 0; i < 4; ++i) {
            if (!this.blends(tile, rotation, directional, i, world)) continue;
            blendresult[3] = blendresult[3] | 1 << i;
        }
        blendresult[4] = 0;
        for (i = 0; i < 4; ++i) {
            int realDir = Mathf.mod(rotation - i, 4);
            if (!this.blends(tile, rotation, directional, i, world) || tile == null || tile.nearbyBuild(realDir) == null || tile.nearbyBuild((int)realDir).block.squareSprite) continue;
            blendresult[4] = blendresult[4] | 1 << i;
        }
        return blendresult;
    }

    default public void transformCase(int num, int[] bits) {
        switch (num) {
            case 0: {
                bits[0] = 3;
                break;
            }
            case 1: {
                bits[0] = 4;
                break;
            }
            case 2: {
                bits[0] = 2;
                break;
            }
            case 3: {
                bits[0] = 2;
                bits[2] = -1;
                break;
            }
            case 4: {
                bits[0] = 1;
                bits[2] = -1;
                break;
            }
            case 5: {
                bits[0] = 1;
            }
        }
    }

    default public boolean facing(int x, int y, int rotation, int x2, int y2) {
        return Point2.equals(x + Geometry.d4((int)rotation).x, y + Geometry.d4((int)rotation).y, x2, y2);
    }

    default public boolean blends(Tile tile, int rotation, @Nullable BuildPlan[] directional, int direction, boolean checkWorld) {
        int realDir = Mathf.mod(rotation - direction, 4);
        if (directional != null && directional[realDir] != null) {
            BuildPlan req = directional[realDir];
            if (this.blends(tile, rotation, req.x, req.y, req.rotation, req.block)) {
                return true;
            }
        }
        return checkWorld && this.blends(tile, rotation, direction);
    }

    default public boolean blends(Tile tile, int rotation, int direction) {
        Building other = tile.nearbyBuild(Mathf.mod(rotation - direction, 4));
        return other != null && other.team == tile.team() && this.blends(tile, rotation, other.tileX(), other.tileY(), other.rotation, other.block);
    }

    default public boolean blendsArmored(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return Point2.equals(tile.x + Geometry.d4((int)rotation).x, tile.y + Geometry.d4((int)rotation).y, otherx, othery) || !otherblock.rotatedOutput(otherx, othery, tile) && Edges.getFacingEdge(otherblock, otherx, othery, tile) != null && Edges.getFacingEdge(otherblock, otherx, othery, tile).relativeTo(tile) == rotation || otherblock.rotatedOutput(otherx, othery, tile) && Point2.equals(otherx + Geometry.d4((int)otherrot).x, othery + Geometry.d4((int)otherrot).y, tile.x, tile.y);
    }

    default public boolean notLookingAt(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return !otherblock.rotatedOutput(otherx, othery, tile) || !Point2.equals(otherx + Geometry.d4((int)otherrot).x, othery + Geometry.d4((int)otherrot).y, tile.x, tile.y);
    }

    default public boolean lookingAtEither(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return Point2.equals(tile.x + Geometry.d4((int)rotation).x, tile.y + Geometry.d4((int)rotation).y, otherx, othery) || !otherblock.rotatedOutput(otherx, othery, tile) || Point2.equals(otherx + Geometry.d4((int)otherrot).x, othery + Geometry.d4((int)otherrot).y, tile.x, tile.y);
    }

    default public boolean lookingAt(Tile tile, int rotation, int otherx, int othery, Block otherblock) {
        Tile facing = Edges.getFacingEdge(otherblock, otherx, othery, tile);
        return facing != null && Point2.equals(tile.x + Geometry.d4((int)rotation).x, tile.y + Geometry.d4((int)rotation).y, facing.x, facing.y);
    }

    public boolean blends(Tile var1, int var2, int var3, int var4, int var5, Block var6);

    private static /* synthetic */ void lambda$getTiling$0(BuildPlan req, BuildPlan[] directionals, BuildPlan other) {
        if (other.breaking || other == req) {
            return;
        }
        int i = 0;
        for (Point2 point : Geometry.d4) {
            int x = req.x + point.x;
            int y = req.y + point.y;
            if (x >= other.x - (other.block.size - 1) / 2 && x <= other.x + other.block.size / 2 && y >= other.y - (other.block.size - 1) / 2 && y <= other.y + other.block.size / 2) {
                directionals[i] = other;
            }
            ++i;
        }
    }

    public static enum SliceMode {
        none,
        bottom,
        top;

    }

    public static class AutotilerHolder {
        static final int[] blendresult = new int[5];
        static final BuildPlan[] directionals = new BuildPlan[4];
    }
}

