/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.struct.ObjectMap;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Fires;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Fire;
import mindustry.gen.Sounds;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class LiquidTurret
extends Turret {
    public ObjectMap<Liquid, BulletType> ammoTypes = new ObjectMap();
    public boolean extinguish = true;

    public LiquidTurret(String name) {
        super(name);
        this.hasLiquids = true;
        this.loopSound = Sounds.loopSpray;
        this.shootSound = Sounds.none;
        this.smokeEffect = Fx.none;
        this.shootEffect = Fx.none;
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = ObjectMap.of(objects);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.ammo, StatValues.ammo(this.ammoTypes));
    }

    @Override
    public void init() {
        this.consume(new ConsumeLiquidFilter(i -> this.ammoTypes.containsKey((Liquid)i), 1.0f){

            @Override
            public void update(Building build) {
            }

            @Override
            public void display(Stats stats) {
            }
        });
        if (this.targetGround) {
            this.ammoTypes.each((item, type) -> {
                this.placeOverlapRange = Math.max(this.placeOverlapRange, this.range + type.rangeChange + this.placeOverlapMargin);
            });
        }
        super.init();
    }

    public class LiquidTurretBuild
    extends Turret.TurretBuild {
        public LiquidTurretBuild() {
            super(LiquidTurret.this);
        }

        @Override
        public boolean shouldActiveSound() {
            return this.wasShooting && this.enabled;
        }

        @Override
        public void updateTile() {
            this.unit.ammo((float)this.unit.type().ammoCapacity * this.liquids.currentAmount() / LiquidTurret.this.liquidCapacity);
            super.updateTile();
        }

        @Override
        public Object senseObject(LAccess sensor) {
            Object object;
            switch (sensor) {
                case currentAmmoType: {
                    object = this.liquids.current();
                    break;
                }
                default: {
                    object = super.senseObject(sensor);
                }
            }
            return object;
        }

        @Override
        protected void findTarget() {
            if (LiquidTurret.this.extinguish && this.liquids.current().canExtinguish()) {
                int tx = World.toTile(this.x);
                int ty = World.toTile(this.y);
                Fire result = null;
                float mindst = 0.0f;
                int tr = (int)(LiquidTurret.this.range / 8.0f);
                for (int x = -tr; x <= tr; ++x) {
                    for (int y = -tr; y <= tr; ++y) {
                        float dst;
                        Tile other = Vars.world.tile(x + tx, y + ty);
                        Fire fire = Fires.get(x + tx, y + ty);
                        float f = dst = fire == null ? 0.0f : this.dst2(fire);
                        if (other == null || fire == null || other.build == this || !Fires.has(other.x, other.y) || !(dst <= LiquidTurret.this.range * LiquidTurret.this.range) || result != null && !(dst < mindst) || other.build != null && other.team() != this.team) continue;
                        result = fire;
                        mindst = dst;
                    }
                }
                if (result != null) {
                    this.target = result;
                    return;
                }
            }
            super.findTarget();
        }

        @Override
        public BulletType useAmmo() {
            if (this.cheating()) {
                return LiquidTurret.this.ammoTypes.get(this.liquids.current());
            }
            BulletType type = LiquidTurret.this.ammoTypes.get(this.liquids.current());
            this.liquids.remove(this.liquids.current(), 1.0f / type.ammoMultiplier);
            return type;
        }

        @Override
        public BulletType peekAmmo() {
            return LiquidTurret.this.ammoTypes.get(this.liquids.current());
        }

        @Override
        public boolean hasAmmo() {
            return LiquidTurret.this.ammoTypes.get(this.liquids.current()) != null && this.liquids.currentAmount() >= 1.0f / LiquidTurret.this.ammoTypes.get((Liquid)this.liquids.current()).ammoMultiplier;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return LiquidTurret.this.ammoTypes.get(liquid) != null && (this.liquids.current() == liquid || !LiquidTurret.this.ammoTypes.containsKey(this.liquids.current()) || this.liquids.get(this.liquids.current()) <= 1.0f / LiquidTurret.this.ammoTypes.get((Liquid)this.liquids.current()).ammoMultiplier + 0.001f);
        }
    }
}

