/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.distribution;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.io.TypeIO;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;

public class DuctJunction
extends Block {
    public Color transparentColor = new Color(0.4f, 0.4f, 0.4f, 0.1f);
    public TextureRegion bottomRegion;
    public TextureRegion topRegion;
    public float speed = 5.0f;

    public DuctJunction(String name) {
        super(name);
        this.update = true;
        this.solid = false;
        this.underBullets = true;
        this.group = BlockGroup.transportation;
        this.unloadable = false;
        this.floating = true;
        this.noUpdateDisabled = true;
        this.hasItems = true;
        this.priority = -1.0f;
        this.envEnabled = 7;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
    }

    @Override
    public void load() {
        super.load();
        this.squareSprite = true;
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public void init() {
        this.itemCapacity = 4;
        super.init();
    }

    public class DuctJunctionBuild
    extends Building {
        Item[] itemdata = new Item[4];
        float[] times = new float[4];

        @Override
        public void draw() {
            Draw.z(29.5f);
            Draw.rect(DuctJunction.this.bottomRegion, this.x, this.y);
            Draw.z(29.6f);
            for (int i = 0; i < 4; ++i) {
                Item current = this.itemdata[i];
                if (current == null) continue;
                float progress = (Mathf.clamp((this.times[i] + 1.0f) / (2.0f - 1.0f / DuctJunction.this.speed)) - 0.5f) * 2.0f;
                Draw.rect(current.fullIcon, this.x + (float)(Geometry.d4x(i) * 8) / 2.0f * progress, this.y + (float)(Geometry.d4y(i) * 8) / 2.0f * progress, 5.0f, 5.0f);
            }
            Draw.color(DuctJunction.this.transparentColor);
            Draw.rect(DuctJunction.this.bottomRegion, this.x, this.y);
            Draw.color();
            Draw.z(29.7f);
            Draw.rect(DuctJunction.this.topRegion, this.x, this.y);
        }

        @Override
        public void updateTile() {
            float inc = this.edelta() / DuctJunction.this.speed * 2.0f;
            for (int i = 0; i < 4; ++i) {
                Item item = this.itemdata[i];
                if (item != null) {
                    Building next;
                    int n = i;
                    this.times[n] = this.times[n] + inc;
                    if (!(this.times[i] >= 1.0f - 1.0f / DuctJunction.this.speed) || (next = this.nearby(i)) == null || next.team != this.team || !next.acceptItem(this, item)) continue;
                    next.handleItem(this, item);
                    this.itemdata[i] = null;
                    this.items.remove(item, 1);
                    int n2 = i;
                    this.times[n2] = this.times[n2] % (1.0f - 1.0f / DuctJunction.this.speed);
                    continue;
                }
                this.times[i] = 0.0f;
            }
        }

        @Override
        public void handleItem(Building source, Item item) {
            byte relative = source.relativeTo(this.tile);
            if (relative == -1) {
                return;
            }
            this.itemdata[relative] = item;
            this.times[relative] = -1.0f;
            this.items.add(item, 1);
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            byte relative = source.relativeTo(this.tile);
            if (relative == -1 || this.itemdata[relative] != null) {
                return false;
            }
            Building to = this.nearby(relative);
            return to != null && to.team == this.team;
        }

        @Override
        public int acceptStack(Item item, int amount, Teamc source) {
            return 0;
        }

        @Override
        public int removeStack(Item item, int amount) {
            int removed = 0;
            for (int i = 0; i < 4 && amount > 0; ++i) {
                if (this.itemdata[i] != item) continue;
                --amount;
                ++removed;
                this.itemdata[i] = null;
                this.items.remove(item, 1);
            }
            return removed;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            for (int i = 0; i < 4; ++i) {
                write.f(this.times[i]);
                TypeIO.writeItem(write, this.itemdata[i]);
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            for (int i = 0; i < 4; ++i) {
                this.times[i] = read.f();
                this.itemdata[i] = TypeIO.readItem(read);
            }
        }
    }
}

