/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.Vars;
import mindustry.gen.TiledState;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class TiledFloor
extends Floor {
    public TextureRegion[][][][] sizedRegions;
    public int maxSize = 3;

    public TiledFloor(String name) {
        super(name);
    }

    public TiledFloor(String name, int variants, int maxSize) {
        super(name);
        this.variants = variants;
        this.maxSize = maxSize;
    }

    @Override
    public void load() {
        super.load();
        this.sizedRegions = new TextureRegion[this.maxSize + 1][Math.max(this.variants, 1)][][];
        for (int size = 1; size <= this.maxSize; ++size) {
            for (int v = 0; v < Math.max(this.variants, 1); ++v) {
                TextureRegion base = Core.atlas.find(this.name + "-" + size + "-" + v);
                int actualSize = size;
                if (!base.found()) {
                    base = Core.atlas.find(this.name + "-" + size);
                }
                if (!base.found()) {
                    actualSize = 1;
                    base = this.region;
                }
                this.sizedRegions[size][v] = base.split(base.width / actualSize, base.height / actualSize);
            }
        }
    }

    long state(Tile tile) {
        return Vars.world.tiles.getTmpFloorState(tile.array());
    }

    @Override
    public void floorChanged(Tile tile) {
        if (Vars.headless) {
            return;
        }
        if (!Vars.world.isGenerating() && TiledState.changes(this.state(tile)) != Vars.world.floorChanges) {
            this.scan(tile);
        }
    }

    void scan(Tile tile) {
        Tile other;
        int cy;
        int cx;
        int size = this.maxSize;
        int changes = Vars.world.floorChanges;
        boolean isOverlay = tile.overlay() == this;
        for (cx = 0; cx < size; ++cx) {
            for (cy = 0; cy < size; ++cy) {
                other = tile.nearby(cx, cy);
                if (other != null && (isOverlay ? other.overlay() : other.floor()) == this && TiledState.changes(this.state(other)) != changes) continue;
                int max = Math.max(cx, cy);
                size = Math.min(max, size);
                size = Math.min(max, size);
            }
        }
        for (cx = 0; cx < size; ++cx) {
            for (cy = 0; cy < size; ++cy) {
                Tile otherRoot;
                other = tile.nearby(cx, cy);
                if (other == null) continue;
                long otherState = this.state(other);
                if (!Vars.headless && TiledState.changes(otherState) != 0 && (otherRoot = other.nearby(-TiledState.x(otherState), -TiledState.y(otherState))) != null) {
                    Core.app.post(() -> Vars.renderer.blocks.floor.recacheTile(otherRoot));
                }
                Vars.world.tiles.setTmpFloorState(other.array(), TiledState.get(cx, cy, size, changes));
                if (Vars.headless || otherState == 0L) continue;
                Core.app.post(() -> Vars.renderer.blocks.floor.recacheTile(other));
            }
        }
    }

    @Override
    public void drawMain(Tile tile) {
        long state = this.state(tile);
        if (TiledState.changes(state) != Vars.world.floorChanges) {
            this.scan(tile);
            state = this.state(tile);
        }
        int size = Mathf.clamp(TiledState.size(state), 1, this.maxSize);
        int cx = TiledState.x(state);
        int cy = TiledState.y(state);
        int variant = this.variant(tile.x - cx, tile.y - cy, this.variants);
        TextureRegion[][] regions = this.sizedRegions[size][variant];
        Draw.rect(regions[Mathf.clamp(cx, 0, regions.length - 1)][Mathf.clamp(size - 1 - cy, 0, regions[0].length - 1)], tile.worldx(), tile.worldy());
    }

    class TiledStateStruct {
        int x;
        int y;
        int size;
        int changes;

        TiledStateStruct() {
        }
    }
}

