/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.geom.Geometry;
import arc.scene.ui.layout.Table;
import arc.struct.IntSet;
import arc.struct.LongSeq;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.world.Tile;
import mindustry.world.blocks.TileBitmask;
import mindustry.world.blocks.logic.LogicDisplay;

public class TileableLogicDisplay
extends LogicDisplay {
    protected static final Seq<TileableLogicDisplayBuild> queue = new Seq();
    protected static final Seq<TileableLogicDisplayBuild> displays = new Seq();
    protected static final ObjectSet<FrameBuffer> buffers = new ObjectSet();
    protected static final IntSet processed = new IntSet();
    public int maxDisplayDimensions = 16;
    public TextureRegion[] tileRegion;
    public TextureRegion backRegion;
    public int frameSize = 6;

    public TileableLogicDisplay(String name) {
        super(name);
        this.displaySize = 32;
    }

    public static void linkDisplays(TileableLogicDisplayBuild start) {
        TileableLogicDisplayBuild root = null;
        int topX = start.tile.x;
        int topY = start.tile.y;
        int botX = start.tile.x;
        int botY = start.tile.y;
        queue.clear();
        displays.clear();
        processed.clear();
        queue.add(start);
        displays.add(start);
        while (!queue.isEmpty()) {
            TileableLogicDisplayBuild next = queue.pop();
            processed.add(next.id);
            if (root == null || next.tile.x < root.tile.x || next.tile.y < root.tile.y) {
                root = next;
            }
            topX = Math.max(next.tile.x, topX);
            topY = Math.max(next.tile.y, topY);
            botX = Math.min(next.tile.x, botX);
            botY = Math.min(next.tile.y, botY);
            for (Building prox : next.proximity) {
                if (!(prox instanceof TileableLogicDisplayBuild)) continue;
                TileableLogicDisplayBuild disp = (TileableLogicDisplayBuild)prox;
                if (!processed.add(disp.id)) continue;
                queue.add(disp);
                displays.add(disp);
            }
        }
        if (root.prevBuffers == null) {
            root.prevBuffers = new Seq();
        }
        buffers.clear();
        for (TileableLogicDisplayBuild member : displays) {
            if (member.buffer == null || !buffers.add(member.buffer)) continue;
            root.prevBuffers.add(new MergeBuffer(member.buffer, member.originX, member.originY, member.tilesWidth, member.tilesHeight));
        }
        int tilesWidth = topX - botX + 1;
        int tilesHeight = topY - botY + 1;
        for (TileableLogicDisplayBuild member : displays) {
            member.needsUpdate = false;
            member.rootDisplay = root;
            member.tilesWidth = tilesWidth;
            member.tilesHeight = tilesHeight;
            member.originX = botX;
            member.originY = botY;
            member.buffer = null;
        }
    }

    public class TileableLogicDisplayBuild
    extends LogicDisplay.LogicDisplayBuild {
        public int tilesWidth = 1;
        public int tilesHeight = 1;
        public int originX;
        public int originY;
        @Nullable
        public Seq<MergeBuffer> prevBuffers;
        public int bits = 0;
        public boolean needsUpdate = false;

        @Override
        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case displayWidth: {
                    d = (float)this.tilesWidth * 32.0f - (float)(TileableLogicDisplay.this.frameSize * 2);
                    break;
                }
                case displayHeight: {
                    d = (float)this.tilesHeight * 32.0f - (float)(TileableLogicDisplay.this.frameSize * 2);
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        @Override
        public void display(Table table) {
            super.display(table);
            if (this.tilesWidth > TileableLogicDisplay.this.maxDisplayDimensions || this.tilesHeight > TileableLogicDisplay.this.maxDisplayDimensions) {
                table.row().add(Core.bundle.format("bar.displaytoolarge", TileableLogicDisplay.this.maxDisplayDimensions, TileableLogicDisplay.this.maxDisplayDimensions)).color(Color.scarlet).growX().wrap();
            }
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.bits = 0;
            for (int i = 0; i < 8; ++i) {
                Tile other = this.tile.nearby(Geometry.d8(i));
                if (other == null || other.block() != this.block || other.team() != this.team) continue;
                this.bits |= 1 << i;
            }
        }

        @Override
        public void getBufferRegion(TextureRegion region) {
            if (this.buffer != null) {
                region.set((Texture)this.buffer.getTexture(), 0, ((Texture)this.buffer.getTexture()).height - TileableLogicDisplay.this.frameSize * 2, ((Texture)this.buffer.getTexture()).width - TileableLogicDisplay.this.frameSize * 2, -(((Texture)this.buffer.getTexture()).height - TileableLogicDisplay.this.frameSize * 2));
            }
        }

        @Override
        public void draw() {
            if (this.needsUpdate) {
                this.needsUpdate = false;
                TileableLogicDisplay.linkDisplays(this);
            }
            Draw.rect(TileableLogicDisplay.this.backRegion, this.x, this.y);
            if (!Vars.renderer.drawDisplays) {
                return;
            }
            if (this.isRoot()) {
                Draw.draw(Draw.z(), () -> {
                    if (this.buffer == null && this.tilesWidth <= TileableLogicDisplay.this.maxDisplayDimensions && this.tilesHeight <= TileableLogicDisplay.this.maxDisplayDimensions) {
                        this.buffer = new FrameBuffer(32 * this.tilesWidth, 32 * this.tilesHeight);
                        Tmp.m1.set(Draw.proj());
                        Tmp.m2.set(Draw.trans());
                        Draw.proj(0.0f, 0.0f, this.buffer.getWidth(), this.buffer.getHeight());
                        this.buffer.begin(Pal.darkerMetal);
                        if (this.prevBuffers != null) {
                            for (MergeBuffer other : this.prevBuffers) {
                                Draw.rect(Draw.wrap((Texture)other.buffer.getTexture()), (float)((other.x - this.originX) * 32) + (float)other.buffer.getWidth() / 2.0f, (float)((other.y - this.originY) * 32) + (float)other.buffer.getHeight() / 2.0f, (float)other.buffer.getWidth(), (float)(-other.buffer.getHeight()));
                                Draw.flush();
                            }
                        }
                        this.buffer.end();
                        Draw.proj(Tmp.m1);
                        Draw.trans(Tmp.m2);
                        Draw.reset();
                    }
                    if (this.prevBuffers != null) {
                        for (MergeBuffer other : this.prevBuffers) {
                            if (other.buffer.isDisposed()) continue;
                            other.buffer.dispose();
                        }
                        this.prevBuffers.clear();
                    }
                });
            }
            this.rootDisplay.processCommands();
            float offset = 0.001f + (this.rootDisplay.buffer == null ? 0.0f : (float)(this.rootDisplay.buffer.hashCode() % 1000000) / 1000000.0f * 0.01f);
            Draw.z(30.0f + offset);
            Draw.blend(Blending.disabled);
            Draw.draw(Draw.z(), () -> {
                if (this.rootDisplay.buffer != null) {
                    int rtx = this.tile.x - this.originX;
                    int rty = this.tile.y - this.originY;
                    Tmp.tr1.set((Texture)this.rootDisplay.buffer.getTexture(), rtx * 32 - TileableLogicDisplay.this.frameSize, rty * 32 - TileableLogicDisplay.this.frameSize, 32, 32);
                    Draw.rect(Tmp.tr1, this.x, this.y, 8.0f, -8.0f);
                }
            });
            Draw.blend();
            Draw.z(30.02f);
            Draw.rect(TileableLogicDisplay.this.tileRegion[TileBitmask.values[this.bits]], this.x, this.y);
        }

        @Override
        public void flushCommands(LongSeq graphicsBuffer) {
            if (this.isRoot()) {
                super.flushCommands(graphicsBuffer);
            } else {
                this.rootDisplay.flushCommands(graphicsBuffer);
            }
        }

        public void updateOthers() {
            for (int i = 0; i < 4; ++i) {
                Tile other = this.tile.nearby(Geometry.d8edge(i));
                if (other == null || other.block() != this.block || other.team() != this.team) continue;
                other.build.onProximityUpdate();
            }
        }

        @Override
        public void onProximityAdded() {
            super.onProximityAdded();
            this.needsUpdate = true;
            this.updateOthers();
        }

        @Override
        public void onProximityRemoved() {
            super.onProximityRemoved();
            processed.clear();
            for (Building other : this.proximity) {
                if (!(other instanceof TileableLogicDisplayBuild)) continue;
                TileableLogicDisplayBuild tl = (TileableLogicDisplayBuild)other;
                if (processed.contains(tl.id)) continue;
                tl.needsUpdate = true;
            }
            this.updateOthers();
        }

        public boolean isRoot() {
            return this.rootDisplay == this;
        }
    }

    static class MergeBuffer {
        FrameBuffer buffer;
        int x;
        int y;
        int width;
        int height;

        MergeBuffer(FrameBuffer buffer, int x, int y, int width, int height) {
            this.buffer = buffer;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return "MergeBuffer{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + '}';
        }
    }
}

