/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.payloads.BlockProducer;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.Stat;

public class Constructor
extends BlockProducer {
    public Seq<Block> filter = new Seq();
    public int minBlockSize = 1;
    public int maxBlockSize = 2;

    public Constructor(String name) {
        super(name);
        this.size = 3;
        this.configurable = true;
        this.clearOnDoubleTap = true;
        this.configClear(tile -> {
            tile.recipe = null;
        });
        this.config(Block.class, (tile, block) -> {
            if (tile.recipe != block) {
                tile.progress = 0.0f;
            }
            if (this.canProduce((Block)block)) {
                tile.recipe = block;
            }
        });
        this.configClear(tile -> {
            tile.recipe = null;
        });
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, "@x@ ~ @x@", this.minBlockSize, this.minBlockSize, this.maxBlockSize, this.maxBlockSize);
        this.stats.addPercent(Stat.buildSpeed, this.buildSpeed);
    }

    @Override
    public void getPlanConfigs(Seq<UnlockableContent> options) {
        options.add(Vars.content.blocks().select(this::canProduce));
    }

    public boolean canProduce(Block b) {
        return b.isVisible() && b.size >= this.minBlockSize && b.size <= this.maxBlockSize && !(b instanceof CoreBlock) && !Vars.state.rules.isBanned(b) && b.environmentBuildable() && (this.filter.isEmpty() || this.filter.contains(b));
    }

    public class ConstructorBuild
    extends BlockProducer.BlockProducerBuild {
        @Nullable
        public Block recipe;

        @Override
        @Nullable
        public Block recipe() {
            return this.recipe;
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(Constructor.this, table, Constructor.this.filter.isEmpty() ? Vars.content.blocks().select(Constructor.this::canProduce) : Constructor.this.filter, () -> this.recipe, this::configure, Constructor.this.selectionRows, Constructor.this.selectionColumns);
        }

        @Override
        public Object config() {
            return this.recipe;
        }

        @Override
        public void drawSelect() {
            if (this.recipe != null) {
                float dx = this.x - (float)(Constructor.this.size * 8) / 2.0f;
                float dy = this.y + (float)(Constructor.this.size * 8) / 2.0f;
                TextureRegion icon = this.recipe.uiIcon;
                Draw.mixcol(Color.darkGray, 1.0f);
                Draw.rect(icon, dx - 0.7f, dy - 1.0f, Draw.scl * Draw.xscl * 24.0f, Draw.scl * Draw.yscl * 24.0f);
                Draw.reset();
                Draw.rect(icon, dx, dy, Draw.scl * Draw.xscl * 24.0f, Draw.scl * Draw.yscl * 24.0f);
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.recipe == null ? -1 : (int)this.recipe.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.recipe = Vars.content.block(read.s());
        }
    }
}

