/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.audio.Sound;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;

public class PayloadVoid
extends PayloadBlock {
    public Effect incinerateEffect = Fx.blastExplosion;
    public Sound incinerateSound = Sounds.unitExplode1;

    public PayloadVoid(String name) {
        super(name);
        this.outputsPayload = false;
        this.acceptsPayload = true;
        this.update = true;
        this.rotate = false;
        this.size = 3;
        this.payloadSpeed = 1.2f;
        this.clipSize = 120.0f;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    public class PayloadVoidBuild
    extends PayloadBlock.PayloadBlockBuild<Payload> {
        @Override
        public void draw() {
            Draw.rect(PayloadVoid.this.region, this.x, this.y);
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i)) continue;
                Draw.rect(PayloadVoid.this.inRegion, this.x, this.y, (float)(i * 90 - 180));
            }
            Draw.rect(PayloadVoid.this.topRegion, this.x, this.y);
            Draw.z(35.0f);
            this.drawPayload();
        }

        @Override
        public boolean acceptUnitPayload(Unit unit) {
            return true;
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.moveInPayload(false) && this.efficiency > 0.0f) {
                this.payload = null;
                PayloadVoid.this.incinerateEffect.at(this);
                PayloadVoid.this.incinerateSound.at(this);
            }
        }
    }
}

