/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.Events;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.ui.Bar;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawPlasma;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class ImpactReactor
extends PowerGenerator {
    public final int timerUse;
    public float warmupSpeed;
    public float itemDuration;

    public ImpactReactor(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.warmupSpeed = 0.001f;
        this.itemDuration = 60.0f;
        this.hasPower = true;
        this.hasLiquids = true;
        this.liquidCapacity = 30.0f;
        this.hasItems = true;
        this.consumesPower = true;
        this.outputsPower = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.reactor, BlockFlag.generator});
        this.lightRadius = 115.0f;
        this.emitLight = true;
        this.envEnabled = -1;
        this.drawer = new DrawMulti(new DrawRegion("-bottom"), new DrawPlasma(), new DrawDefault());
        this.explosionShake = 6.0f;
        this.explosionShakeDuration = 16.0f;
        this.explosionDamage = 7600;
        this.explosionMinWarmup = 0.3f;
        this.explodeEffect = Fx.impactReactorExplosion;
        this.explodeSound = Sounds.explosionReactor2;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("power", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", Strings.fixed(Math.max(entity.getPowerProduction() - this.consPower.usage, 0.0f) * 60.0f * entity.timeScale(), 1)), () -> Pal.powerBar, () -> entity.productionEfficiency));
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(Stat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
    }

    public class ImpactReactorBuild
    extends PowerGenerator.GeneratorBuild {
        public float warmup;
        public float totalProgress;

        public ImpactReactorBuild() {
            super(ImpactReactor.this);
        }

        @Override
        public void updateTile() {
            if (this.efficiency >= 0.9999f && this.power.status >= 0.99f) {
                boolean prevOut = this.getPowerProduction() <= ImpactReactor.this.consPower.requestedPower(this);
                this.warmup = Mathf.lerpDelta(this.warmup, 1.0f, ImpactReactor.this.warmupSpeed * this.timeScale);
                if (Mathf.equal(this.warmup, 1.0f, 0.001f)) {
                    this.warmup = 1.0f;
                }
                if (!prevOut && this.getPowerProduction() > ImpactReactor.this.consPower.requestedPower(this)) {
                    Events.fire(EventType.Trigger.impactPower);
                }
                if (this.timer(ImpactReactor.this.timerUse, ImpactReactor.this.itemDuration / this.timeScale)) {
                    this.consume();
                }
            } else {
                this.warmup = Mathf.lerpDelta(this.warmup, 0.0f, 0.01f);
            }
            this.totalProgress += this.warmup * Time.delta;
            this.productionEfficiency = Mathf.pow(this.warmup, 5.0f);
        }

        @Override
        public float warmup() {
            return this.warmup;
        }

        @Override
        public float totalProgress() {
            return this.totalProgress;
        }

        @Override
        public float ambientVolume() {
            return this.warmup;
        }

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.heat) {
                return this.warmup;
            }
            return super.sense(sensor);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.warmup = read.f();
        }
    }
}

