/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.power;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.graphics.Drawf;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class ThermalGenerator
extends PowerGenerator {
    public Effect generateEffect = Fx.none;
    public float effectChance = 0.05f;
    public float minEfficiency = 0.0f;
    public float displayEfficiencyScale = 1.0f;
    public boolean displayEfficiency = true;
    @Nullable
    public LiquidStack outputLiquid;
    public Attribute attribute = Attribute.heat;

    public ThermalGenerator(String name) {
        super(name);
        this.noUpdateDisabled = true;
    }

    @Override
    public float getDisplayedPowerProduction() {
        return this.powerProduction / this.displayEfficiencyScale;
    }

    @Override
    public void init() {
        if (this.outputLiquid != null) {
            this.outputsLiquid = true;
            this.hasLiquids = true;
        }
        this.emitLight = true;
        super.init();
        this.lightClipSize = Math.max(this.lightClipSize, 45.0f * (float)this.size * 2.0f * 2.0f);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.tiles, this.attribute, this.floating, (float)(this.size * this.size) * this.displayEfficiencyScale, !this.displayEfficiency);
        this.stats.remove(this.generationType);
        this.stats.add(this.generationType, this.powerProduction * 60.0f / this.displayEfficiencyScale, StatUnit.powerSecond);
        if (this.outputLiquid != null) {
            this.stats.add(Stat.output, StatValues.liquid(this.outputLiquid.liquid, this.outputLiquid.amount * (float)this.size * (float)this.size * 60.0f, true));
        }
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (this.displayEfficiency) {
            this.drawPlaceText(Core.bundle.formatFloat("bar.efficiency", this.sumAttribute(this.attribute, x, y) * 100.0f * this.displayEfficiencyScale, 1), x, y, valid);
        }
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return tile.getLinkedTilesAs((Block)this, tempTiles).sumf(other -> other.floor().attributes.get(this.attribute)) > this.minEfficiency;
    }

    public class ThermalGeneratorBuild
    extends PowerGenerator.GeneratorBuild {
        public float sum;

        @Override
        public void updateTile() {
            this.productionEfficiency = this.sum + ThermalGenerator.this.attribute.env();
            if (this.productionEfficiency > 0.1f && Mathf.chanceDelta(ThermalGenerator.this.effectChance)) {
                ThermalGenerator.this.generateEffect.at(this.x + Mathf.range(3.0f), this.y + Mathf.range(3.0f));
            }
            if (ThermalGenerator.this.outputLiquid != null) {
                float added = Math.min(this.productionEfficiency * this.delta() * ThermalGenerator.this.outputLiquid.amount, ThermalGenerator.this.liquidCapacity - this.liquids.get(ThermalGenerator.this.outputLiquid.liquid));
                this.liquids.add(ThermalGenerator.this.outputLiquid.liquid, added);
                this.dumpLiquid(ThermalGenerator.this.outputLiquid.liquid);
            }
        }

        @Override
        public void afterPickedUp() {
            super.afterPickedUp();
            this.sum = 0.0f;
        }

        @Override
        public float totalProgress() {
            return this.enabled && this.sum > 0.0f ? super.totalProgress() : 0.0f;
        }

        @Override
        public void drawLight() {
            Drawf.light(this.x, this.y, (40.0f + Mathf.absin(10.0f, 5.0f)) * Math.min(this.productionEfficiency, 2.0f) * (float)ThermalGenerator.this.size, Color.scarlet, 0.4f);
        }

        @Override
        public void onProximityAdded() {
            super.onProximityAdded();
            this.sum = ThermalGenerator.this.sumAttribute(ThermalGenerator.this.attribute, this.tile.x, this.tile.y);
        }
    }
}

