/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.math.Mathf;
import mindustry.gen.Sounds;
import mindustry.world.blocks.production.SolidPump;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Fracker
extends SolidPump {
    public float itemUseTime = 100.0f;

    public Fracker(String name) {
        super(name);
        this.hasItems = true;
        this.ambientSound = Sounds.loopDrill;
        this.ambientSoundVolume = 0.03f;
        this.envRequired |= 0x20;
    }

    @Override
    public void setStats() {
        this.stats.timePeriod = this.itemUseTime;
        super.setStats();
        this.stats.add(Stat.productionTime, this.itemUseTime / 60.0f, StatUnit.seconds);
    }

    public class FrackerBuild
    extends SolidPump.SolidPumpBuild {
        public float accumulator;

        public FrackerBuild() {
            super(Fracker.this);
        }

        @Override
        public void updateTile() {
            if (this.efficiency > 0.0f) {
                if (this.accumulator >= Fracker.this.itemUseTime) {
                    this.consume();
                    this.accumulator -= Fracker.this.itemUseTime;
                }
                super.updateTile();
                this.accumulator += this.delta() * this.efficiency;
            } else {
                this.warmup = Mathf.lerpDelta(this.warmup, 0.0f, 0.02f);
                this.lastPump = 0.0f;
                this.dumpLiquid(Fracker.this.result);
            }
        }
    }
}

