/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.BuildingTetherc;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.UnitTetherBlock;

public class UnitCargoLoader
extends Block {
    public UnitType unitType = UnitTypes.manifold;
    public float unitBuildTime = 480.0f;
    public float polyStroke = 1.8f;
    public float polyRadius = 8.0f;
    public int polySides = 6;
    public float polyRotateSpeed = 1.0f;
    public Color polyColor = Pal.accent;

    public UnitCargoLoader(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.hasItems = true;
        this.itemCapacity = 200;
        this.ambientSound = Sounds.loopUnitBuilding;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("units", e -> new Bar(() -> Core.bundle.format("bar.unitcap", Fonts.getUnicodeStr(this.unitType.name), e.team.data().countType(this.unitType), this.unitType.useUnitCap ? Units.getStringCap(e.team) : "\u221e"), () -> Pal.power, () -> this.unitType.useUnitCap ? (float)e.team.data().countType(this.unitType) / (float)Units.getCap(e.team) : 1.0f));
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return super.canPlaceOn(tile, team, rotation) && Units.canCreate(team, this.unitType);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (!Units.canCreate(Vars.player.team(), this.unitType)) {
            this.drawPlaceText(Core.bundle.get("bar.cargounitcap"), x, y, valid);
        }
    }

    public static void unitTetherBlockSpawned(Tile tile, int id) {
        Building building;
        if (tile == null || !((building = tile.build) instanceof UnitTetherBlock)) {
            return;
        }
        UnitTetherBlock build = (UnitTetherBlock)((Object)building);
        build.spawned(id);
    }

    public class UnitTransportSourceBuild
    extends Building
    implements UnitTetherBlock {
        public int readUnitId = -1;
        public float buildProgress;
        public float totalProgress;
        public float warmup;
        public float readyness;
        @Nullable
        public Unit unit;

        @Override
        public void updateTile() {
            if (this.unit != null && (this.unit.dead || !this.unit.isAdded())) {
                this.unit = null;
            }
            if (this.readUnitId != -1) {
                this.unit = Groups.unit.getByID(this.readUnitId);
                if (this.unit != null || !Vars.net.client()) {
                    this.readUnitId = -1;
                }
            }
            this.warmup = Mathf.approachDelta(this.warmup, this.efficiency, 0.016666668f);
            this.readyness = Mathf.approachDelta(this.readyness, this.unit != null ? 1.0f : 0.0f, 0.016666668f);
            if (this.unit == null && Units.canCreate(this.team, UnitCargoLoader.this.unitType)) {
                this.buildProgress += this.edelta() / UnitCargoLoader.this.unitBuildTime;
                this.totalProgress += this.edelta();
                if (this.buildProgress >= 1.0f && !Vars.net.client()) {
                    this.unit = UnitCargoLoader.this.unitType.create(this.team);
                    Unit unit = this.unit;
                    if (unit instanceof BuildingTetherc) {
                        BuildingTetherc bt = (BuildingTetherc)((Object)unit);
                        bt.building(this);
                    }
                    this.unit.set(this.x, this.y);
                    this.unit.rotation = 90.0f;
                    this.unit.add();
                    Call.unitTetherBlockSpawned(this.tile, this.unit.id);
                }
            }
        }

        @Override
        public void spawned(int id) {
            Fx.spawn.at(this.x, this.y);
            this.buildProgress = 0.0f;
            if (Vars.net.client()) {
                this.readUnitId = id;
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.total() < UnitCargoLoader.this.itemCapacity;
        }

        @Override
        public boolean shouldConsume() {
            return this.unit == null;
        }

        @Override
        public void draw() {
            Draw.rect(this.block.region, this.x, this.y);
            if (this.unit == null) {
                Draw.draw(35.0f, () -> Drawf.construct((Building)this, UnitCargoLoader.this.unitType.fullIcon, 0.0f, this.buildProgress, this.warmup, this.totalProgress));
            } else {
                Draw.z(99.99f);
                Draw.color(UnitCargoLoader.this.polyColor);
                Lines.stroke(UnitCargoLoader.this.polyStroke * this.readyness);
                Lines.poly(this.x, this.y, UnitCargoLoader.this.polySides, UnitCargoLoader.this.polyRadius, Time.time * UnitCargoLoader.this.polyRotateSpeed);
                Draw.reset();
                Draw.z(30.0f);
            }
        }

        @Override
        public float totalProgress() {
            return this.totalProgress;
        }

        @Override
        public float progress() {
            return this.buildProgress;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.unit == null ? -1 : this.unit.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.readUnitId = read.i();
        }
    }
}

