/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;

public class ConsumeLiquid
extends ConsumeLiquidBase {
    public final Liquid liquid;

    public ConsumeLiquid(Liquid liquid, float amount) {
        super(amount);
        this.liquid = liquid;
    }

    protected ConsumeLiquid() {
        this(null, 0.0f);
    }

    @Override
    public void apply(Block block) {
        super.apply(block);
        block.liquidFilter[this.liquid.id] = true;
    }

    @Override
    public void build(Building build, Table table) {
        table.add(new ReqImage(this.liquid.uiIcon, () -> build.liquids.get(this.liquid) > 0.0f)).size(32.0f).top().left();
    }

    @Override
    public void update(Building build) {
        build.liquids.remove(this.liquid, this.amount * build.edelta() * this.multiplier.get(build));
    }

    @Override
    public float efficiency(Building build) {
        float ed = build.edelta() * build.efficiencyScale();
        if (ed <= 1.0E-8f) {
            return 0.0f;
        }
        return Math.min(build.liquids.get(this.liquid) / (this.amount * ed * this.multiplier.get(build)), 1.0f);
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, this.liquid, this.amount * 60.0f, true);
    }

    @Override
    public boolean consumes(Liquid liquid) {
        return liquid == this.liquid;
    }
}

