/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import mindustry.type.Liquid;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ConsumeLiquidFlammable
extends ConsumeLiquidFilter {
    public float minFlammability;

    public ConsumeLiquidFlammable(float minFlammability, float amount) {
        this.amount = amount;
        this.minFlammability = minFlammability;
        this.filter = liquid -> liquid.flammability >= this.minFlammability;
    }

    public ConsumeLiquidFlammable(float amount) {
        this(0.2f, amount);
    }

    public ConsumeLiquidFlammable() {
        this(0.2f);
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, StatValues.liquidEffMultiplier(l -> l.flammability, this.amount * 60.0f, this.filter));
    }

    @Override
    public float liquidEfficiencyMultiplier(Liquid liquid) {
        return liquid.flammability;
    }
}

