/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_AsyncIOOutcome;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLAsyncIO {
    public static final int SDL_ASYNCIO_TASK_READ = 0;
    public static final int SDL_ASYNCIO_TASK_WRITE = 1;
    public static final int SDL_ASYNCIO_TASK_CLOSE = 2;
    public static final int SDL_ASYNCIO_COMPLETE = 0;
    public static final int SDL_ASYNCIO_FAILURE = 1;
    public static final int SDL_ASYNCIO_CANCELED = 2;

    protected SDLAsyncIO() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_AsyncIOFromFile(long file, long mode) {
        long __functionAddress = Functions.AsyncIOFromFile;
        return JNI.invokePPP(file, mode, __functionAddress);
    }

    @NativeType(value="SDL_AsyncIO *")
    public static long SDL_AsyncIOFromFile(@NativeType(value="char const *") ByteBuffer file, @NativeType(value="char const *") ByteBuffer mode) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file);
            Checks.checkNT1(mode);
        }
        return SDLAsyncIO.nSDL_AsyncIOFromFile(MemoryUtil.memAddress(file), MemoryUtil.memAddress(mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_AsyncIO *")
    public static long SDL_AsyncIOFromFile(@NativeType(value="char const *") CharSequence file, @NativeType(value="char const *") CharSequence mode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file, true);
            long fileEncoded = stack.getPointerAddress();
            stack.nASCII(mode, true);
            long modeEncoded = stack.getPointerAddress();
            long l = SDLAsyncIO.nSDL_AsyncIOFromFile(fileEncoded, modeEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="Sint64")
    public static long SDL_GetAsyncIOSize(@NativeType(value="SDL_AsyncIO *") long asyncio) {
        long __functionAddress = Functions.GetAsyncIOSize;
        if (Checks.CHECKS) {
            Checks.check(asyncio);
        }
        return JNI.invokePJ(asyncio, __functionAddress);
    }

    public static boolean nSDL_ReadAsyncIO(long asyncio, long ptr, long offset, long size, long queue, long userdata) {
        long __functionAddress = Functions.ReadAsyncIO;
        if (Checks.CHECKS) {
            Checks.check(asyncio);
            Checks.check(queue);
        }
        return JNI.invokePPJJPPZ(asyncio, ptr, offset, size, queue, userdata, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ReadAsyncIO(@NativeType(value="SDL_AsyncIO *") long asyncio, @NativeType(value="void *") ByteBuffer ptr, @NativeType(value="Uint64") long offset, @NativeType(value="SDL_AsyncIOQueue *") long queue, @NativeType(value="void *") long userdata) {
        return SDLAsyncIO.nSDL_ReadAsyncIO(asyncio, MemoryUtil.memAddress(ptr), offset, ptr.remaining(), queue, userdata);
    }

    public static boolean nSDL_WriteAsyncIO(long asyncio, long ptr, long offset, long size, long queue, long userdata) {
        long __functionAddress = Functions.WriteAsyncIO;
        if (Checks.CHECKS) {
            Checks.check(asyncio);
            Checks.check(queue);
        }
        return JNI.invokePPJJPPZ(asyncio, ptr, offset, size, queue, userdata, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_WriteAsyncIO(@NativeType(value="SDL_AsyncIO *") long asyncio, @NativeType(value="void *") ByteBuffer ptr, @NativeType(value="Uint64") long offset, @NativeType(value="SDL_AsyncIOQueue *") long queue, @NativeType(value="void *") long userdata) {
        return SDLAsyncIO.nSDL_WriteAsyncIO(asyncio, MemoryUtil.memAddress(ptr), offset, ptr.remaining(), queue, userdata);
    }

    @NativeType(value="bool")
    public static boolean SDL_CloseAsyncIO(@NativeType(value="SDL_AsyncIO *") long asyncio, @NativeType(value="bool") boolean flush, @NativeType(value="SDL_AsyncIOQueue *") long queue, @NativeType(value="void *") long userdata) {
        long __functionAddress = Functions.CloseAsyncIO;
        if (Checks.CHECKS) {
            Checks.check(asyncio);
            Checks.check(queue);
        }
        return JNI.invokePPPZ(asyncio, flush, queue, userdata, __functionAddress);
    }

    @NativeType(value="SDL_AsyncIOQueue *")
    public static long SDL_CreateAsyncIOQueue() {
        long __functionAddress = Functions.CreateAsyncIOQueue;
        return JNI.invokeP(__functionAddress);
    }

    public static void SDL_DestroyAsyncIOQueue(@NativeType(value="SDL_AsyncIOQueue *") long queue) {
        long __functionAddress = Functions.DestroyAsyncIOQueue;
        if (Checks.CHECKS) {
            Checks.check(queue);
        }
        JNI.invokePV(queue, __functionAddress);
    }

    public static boolean nSDL_GetAsyncIOResult(long queue, long outcome) {
        long __functionAddress = Functions.GetAsyncIOResult;
        if (Checks.CHECKS) {
            Checks.check(queue);
        }
        return JNI.invokePPZ(queue, outcome, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetAsyncIOResult(@NativeType(value="SDL_AsyncIOQueue *") long queue, @NativeType(value="SDL_AsyncIOOutcome *") SDL_AsyncIOOutcome outcome) {
        return SDLAsyncIO.nSDL_GetAsyncIOResult(queue, outcome.address());
    }

    public static boolean nSDL_WaitAsyncIOResult(long queue, long outcome, int timeoutMS) {
        long __functionAddress = Functions.WaitAsyncIOResult;
        if (Checks.CHECKS) {
            Checks.check(queue);
        }
        return JNI.invokePPZ(queue, outcome, timeoutMS, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_WaitAsyncIOResult(@NativeType(value="SDL_AsyncIOQueue *") long queue, @NativeType(value="SDL_AsyncIOOutcome *") SDL_AsyncIOOutcome outcome, @NativeType(value="Sint32") int timeoutMS) {
        return SDLAsyncIO.nSDL_WaitAsyncIOResult(queue, outcome.address(), timeoutMS);
    }

    public static void SDL_SignalAsyncIOQueue(@NativeType(value="SDL_AsyncIOQueue *") long queue) {
        long __functionAddress = Functions.SignalAsyncIOQueue;
        if (Checks.CHECKS) {
            Checks.check(queue);
        }
        JNI.invokePV(queue, __functionAddress);
    }

    public static boolean nSDL_LoadFileAsync(long file, long queue, long userdata) {
        long __functionAddress = Functions.LoadFileAsync;
        if (Checks.CHECKS) {
            Checks.check(queue);
        }
        return JNI.invokePPPZ(file, queue, userdata, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_LoadFileAsync(@NativeType(value="char const *") ByteBuffer file, @NativeType(value="SDL_AsyncIOQueue *") long queue, @NativeType(value="void *") long userdata) {
        if (Checks.CHECKS) {
            Checks.checkNT1(file);
        }
        return SDLAsyncIO.nSDL_LoadFileAsync(MemoryUtil.memAddress(file), queue, userdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_LoadFileAsync(@NativeType(value="char const *") CharSequence file, @NativeType(value="SDL_AsyncIOQueue *") long queue, @NativeType(value="void *") long userdata) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(file, true);
            long fileEncoded = stack.getPointerAddress();
            boolean bl = SDLAsyncIO.nSDL_LoadFileAsync(fileEncoded, queue, userdata);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long AsyncIOFromFile = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_AsyncIOFromFile");
        public static final long GetAsyncIOSize = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetAsyncIOSize");
        public static final long ReadAsyncIO = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ReadAsyncIO");
        public static final long WriteAsyncIO = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_WriteAsyncIO");
        public static final long CloseAsyncIO = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CloseAsyncIO");
        public static final long CreateAsyncIOQueue = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateAsyncIOQueue");
        public static final long DestroyAsyncIOQueue = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_DestroyAsyncIOQueue");
        public static final long GetAsyncIOResult = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetAsyncIOResult");
        public static final long WaitAsyncIOResult = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_WaitAsyncIOResult");
        public static final long SignalAsyncIOQueue = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SignalAsyncIOQueue");
        public static final long LoadFileAsync = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_LoadFileAsync");

        private Functions() {
        }
    }
}

