/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLError {
    protected SDLError() {
        throw new UnsupportedOperationException();
    }

    public static boolean nSDL_SetError(long fmt) {
        long __functionAddress = Functions.SetError;
        return JNI.invokePZ(fmt, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetError(@NativeType(value="char const *") ByteBuffer fmt) {
        if (Checks.CHECKS) {
            Checks.checkNT1(fmt);
        }
        return SDLError.nSDL_SetError(MemoryUtil.memAddress(fmt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetError(@NativeType(value="char const *") CharSequence fmt) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(fmt, true);
            long fmtEncoded = stack.getPointerAddress();
            boolean bl = SDLError.nSDL_SetError(fmtEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetErrorV(long fmt, long ap) {
        long __functionAddress = Functions.SetErrorV;
        if (Checks.CHECKS) {
            Checks.check(ap);
        }
        return JNI.invokePPZ(fmt, ap, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetErrorV(@NativeType(value="char const *") ByteBuffer fmt, @NativeType(value="va_list") long ap) {
        if (Checks.CHECKS) {
            Checks.checkNT1(fmt);
        }
        return SDLError.nSDL_SetErrorV(MemoryUtil.memAddress(fmt), ap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetErrorV(@NativeType(value="char const *") CharSequence fmt, @NativeType(value="va_list") long ap) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(fmt, true);
            long fmtEncoded = stack.getPointerAddress();
            boolean bl = SDLError.nSDL_SetErrorV(fmtEncoded, ap);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="bool")
    public static boolean SDL_OutOfMemory() {
        long __functionAddress = Functions.OutOfMemory;
        return JNI.invokeZ(__functionAddress);
    }

    public static long nSDL_GetError() {
        long __functionAddress = Functions.GetError;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetError() {
        long __result = SDLError.nSDL_GetError();
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="bool")
    public static boolean SDL_ClearError() {
        long __functionAddress = Functions.ClearError;
        return JNI.invokeZ(__functionAddress);
    }

    public static final class Functions {
        public static final long SetError = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetError");
        public static final long SetErrorV = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetErrorV");
        public static final long OutOfMemory = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_OutOfMemory");
        public static final long GetError = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetError");
        public static final long ClearError = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ClearError");

        private Functions() {
        }
    }
}

