/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDLStdinc;
import org.lwjgl.sdl.SDL_Color;
import org.lwjgl.sdl.SDL_Palette;
import org.lwjgl.sdl.SDL_PixelFormatDetails;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLPixels {
    public static final int SDL_ALPHA_OPAQUE = 255;
    public static final int SDL_ALPHA_TRANSPARENT = 0;
    public static final float SDL_ALPHA_OPAQUE_FLOAT = 1.0f;
    public static final float SDL_ALPHA_TRANSPARENT_FLOAT = 0.0f;
    public static final int SDL_PIXELTYPE_UNKNOWN = 0;
    public static final int SDL_PIXELTYPE_INDEX1 = 1;
    public static final int SDL_PIXELTYPE_INDEX4 = 2;
    public static final int SDL_PIXELTYPE_INDEX8 = 3;
    public static final int SDL_PIXELTYPE_PACKED8 = 4;
    public static final int SDL_PIXELTYPE_PACKED16 = 5;
    public static final int SDL_PIXELTYPE_PACKED32 = 6;
    public static final int SDL_PIXELTYPE_ARRAYU8 = 7;
    public static final int SDL_PIXELTYPE_ARRAYU16 = 8;
    public static final int SDL_PIXELTYPE_ARRAYU32 = 9;
    public static final int SDL_PIXELTYPE_ARRAYF16 = 10;
    public static final int SDL_PIXELTYPE_ARRAYF32 = 11;
    public static final int SDL_PIXELTYPE_INDEX2 = 12;
    public static final int SDL_BITMAPORDER_NONE = 0;
    public static final int SDL_BITMAPORDER_4321 = 1;
    public static final int SDL_BITMAPORDER_1234 = 2;
    public static final int SDL_PACKEDORDER_NONE = 0;
    public static final int SDL_PACKEDORDER_XRGB = 1;
    public static final int SDL_PACKEDORDER_RGBX = 2;
    public static final int SDL_PACKEDORDER_ARGB = 3;
    public static final int SDL_PACKEDORDER_RGBA = 4;
    public static final int SDL_PACKEDORDER_XBGR = 5;
    public static final int SDL_PACKEDORDER_BGRX = 6;
    public static final int SDL_PACKEDORDER_ABGR = 7;
    public static final int SDL_PACKEDORDER_BGRA = 8;
    public static final int SDL_ARRAYORDER_NONE = 0;
    public static final int SDL_ARRAYORDER_RGB = 1;
    public static final int SDL_ARRAYORDER_RGBA = 2;
    public static final int SDL_ARRAYORDER_ARGB = 3;
    public static final int SDL_ARRAYORDER_BGR = 4;
    public static final int SDL_ARRAYORDER_BGRA = 5;
    public static final int SDL_ARRAYORDER_ABGR = 6;
    public static final int SDL_PACKEDLAYOUT_NONE = 0;
    public static final int SDL_PACKEDLAYOUT_332 = 1;
    public static final int SDL_PACKEDLAYOUT_4444 = 2;
    public static final int SDL_PACKEDLAYOUT_1555 = 3;
    public static final int SDL_PACKEDLAYOUT_5551 = 4;
    public static final int SDL_PACKEDLAYOUT_565 = 5;
    public static final int SDL_PACKEDLAYOUT_8888 = 6;
    public static final int SDL_PACKEDLAYOUT_2101010 = 7;
    public static final int SDL_PACKEDLAYOUT_1010102 = 8;
    public static final int SDL_PIXELFORMAT_UNKNOWN = 0;
    public static final int SDL_PIXELFORMAT_INDEX1LSB = 0x11100100;
    public static final int SDL_PIXELFORMAT_INDEX1MSB = 0x11200100;
    public static final int SDL_PIXELFORMAT_INDEX2LSB = 470811136;
    public static final int SDL_PIXELFORMAT_INDEX2MSB = 471859712;
    public static final int SDL_PIXELFORMAT_INDEX4LSB = 303039488;
    public static final int SDL_PIXELFORMAT_INDEX4MSB = 304088064;
    public static final int SDL_PIXELFORMAT_INDEX8 = 318769153;
    public static final int SDL_PIXELFORMAT_RGB332 = 336660481;
    public static final int SDL_PIXELFORMAT_XRGB4444 = 353504258;
    public static final int SDL_PIXELFORMAT_XBGR4444 = 357698562;
    public static final int SDL_PIXELFORMAT_XRGB1555 = 353570562;
    public static final int SDL_PIXELFORMAT_XBGR1555 = 357764866;
    public static final int SDL_PIXELFORMAT_ARGB4444 = 355602434;
    public static final int SDL_PIXELFORMAT_RGBA4444 = 356651010;
    public static final int SDL_PIXELFORMAT_ABGR4444 = 359796738;
    public static final int SDL_PIXELFORMAT_BGRA4444 = 360845314;
    public static final int SDL_PIXELFORMAT_ARGB1555 = 355667970;
    public static final int SDL_PIXELFORMAT_RGBA5551 = 356782082;
    public static final int SDL_PIXELFORMAT_ABGR1555 = 359862274;
    public static final int SDL_PIXELFORMAT_BGRA5551 = 360976386;
    public static final int SDL_PIXELFORMAT_RGB565 = 353701890;
    public static final int SDL_PIXELFORMAT_BGR565 = 357896194;
    public static final int SDL_PIXELFORMAT_RGB24 = 386930691;
    public static final int SDL_PIXELFORMAT_BGR24 = 390076419;
    public static final int SDL_PIXELFORMAT_XRGB8888 = 370546692;
    public static final int SDL_PIXELFORMAT_RGBX8888 = 371595268;
    public static final int SDL_PIXELFORMAT_XBGR8888 = 374740996;
    public static final int SDL_PIXELFORMAT_BGRX8888 = 375789572;
    public static final int SDL_PIXELFORMAT_ARGB8888 = 372645892;
    public static final int SDL_PIXELFORMAT_RGBA8888 = 373694468;
    public static final int SDL_PIXELFORMAT_ABGR8888 = 376840196;
    public static final int SDL_PIXELFORMAT_BGRA8888 = 377888772;
    public static final int SDL_PIXELFORMAT_XRGB2101010 = 370614276;
    public static final int SDL_PIXELFORMAT_XBGR2101010 = 374808580;
    public static final int SDL_PIXELFORMAT_ARGB2101010 = 372711428;
    public static final int SDL_PIXELFORMAT_ABGR2101010 = 376905732;
    public static final int SDL_PIXELFORMAT_RGB48 = 403714054;
    public static final int SDL_PIXELFORMAT_BGR48 = 406859782;
    public static final int SDL_PIXELFORMAT_RGBA64 = 404766728;
    public static final int SDL_PIXELFORMAT_ARGB64 = 405815304;
    public static final int SDL_PIXELFORMAT_BGRA64 = 407912456;
    public static final int SDL_PIXELFORMAT_ABGR64 = 408961032;
    public static final int SDL_PIXELFORMAT_RGB48_FLOAT = 437268486;
    public static final int SDL_PIXELFORMAT_BGR48_FLOAT = 440414214;
    public static final int SDL_PIXELFORMAT_RGBA64_FLOAT = 438321160;
    public static final int SDL_PIXELFORMAT_ARGB64_FLOAT = 439369736;
    public static final int SDL_PIXELFORMAT_BGRA64_FLOAT = 441466888;
    public static final int SDL_PIXELFORMAT_ABGR64_FLOAT = 442515464;
    public static final int SDL_PIXELFORMAT_RGB96_FLOAT = 454057996;
    public static final int SDL_PIXELFORMAT_BGR96_FLOAT = 457203724;
    public static final int SDL_PIXELFORMAT_RGBA128_FLOAT = 455114768;
    public static final int SDL_PIXELFORMAT_ARGB128_FLOAT = 456163344;
    public static final int SDL_PIXELFORMAT_BGRA128_FLOAT = 458260496;
    public static final int SDL_PIXELFORMAT_ABGR128_FLOAT = 459309072;
    public static final int SDL_PIXELFORMAT_YV12 = 842094169;
    public static final int SDL_PIXELFORMAT_IYUV = 1448433993;
    public static final int SDL_PIXELFORMAT_YUY2 = 844715353;
    public static final int SDL_PIXELFORMAT_UYVY = 0x59565955;
    public static final int SDL_PIXELFORMAT_YVYU = 0x55595659;
    public static final int SDL_PIXELFORMAT_NV12 = 842094158;
    public static final int SDL_PIXELFORMAT_NV21 = 825382478;
    public static final int SDL_PIXELFORMAT_P010 = 808530000;
    public static final int SDL_PIXELFORMAT_EXTERNAL_OES = 542328143;
    public static final int SDL_PIXELFORMAT_MJPG = 1196444237;
    public static final int SDL_PIXELFORMAT_RGBA32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 376840196 : 373694468;
    public static final int SDL_PIXELFORMAT_ARGB32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 377888772 : 372645892;
    public static final int SDL_PIXELFORMAT_BGRA32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 372645892 : 377888772;
    public static final int SDL_PIXELFORMAT_ABGR32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 373694468 : 376840196;
    public static final int SDL_PIXELFORMAT_RGBX32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 374740996 : 371595268;
    public static final int SDL_PIXELFORMAT_XRGB32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 375789572 : 370546692;
    public static final int SDL_PIXELFORMAT_BGRX32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 370546692 : 375789572;
    public static final int SDL_PIXELFORMAT_XBGR32 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 371595268 : 374740996;
    public static final int SDL_COLOR_TYPE_UNKNOWN = 0;
    public static final int SDL_COLOR_TYPE_RGB = 1;
    public static final int SDL_COLOR_TYPE_YCBCR = 2;
    public static final int SDL_COLOR_RANGE_UNKNOWN = 0;
    public static final int SDL_COLOR_RANGE_LIMITED = 1;
    public static final int SDL_COLOR_RANGE_FULL = 2;
    public static final int SDL_COLOR_PRIMARIES_UNKNOWN = 0;
    public static final int SDL_COLOR_PRIMARIES_BT709 = 1;
    public static final int SDL_COLOR_PRIMARIES_UNSPECIFIED = 2;
    public static final int SDL_COLOR_PRIMARIES_BT470M = 4;
    public static final int SDL_COLOR_PRIMARIES_BT470BG = 5;
    public static final int SDL_COLOR_PRIMARIES_BT601 = 6;
    public static final int SDL_COLOR_PRIMARIES_SMPTE240 = 7;
    public static final int SDL_COLOR_PRIMARIES_GENERIC_FILM = 8;
    public static final int SDL_COLOR_PRIMARIES_BT2020 = 9;
    public static final int SDL_COLOR_PRIMARIES_XYZ = 10;
    public static final int SDL_COLOR_PRIMARIES_SMPTE431 = 11;
    public static final int SDL_COLOR_PRIMARIES_SMPTE432 = 12;
    public static final int SDL_COLOR_PRIMARIES_EBU3213 = 22;
    public static final int SDL_COLOR_PRIMARIES_CUSTOM = 31;
    public static final int SDL_TRANSFER_CHARACTERISTICS_UNKNOWN = 0;
    public static final int SDL_TRANSFER_CHARACTERISTICS_BT709 = 1;
    public static final int SDL_TRANSFER_CHARACTERISTICS_UNSPECIFIED = 2;
    public static final int SDL_TRANSFER_CHARACTERISTICS_GAMMA22 = 4;
    public static final int SDL_TRANSFER_CHARACTERISTICS_GAMMA28 = 5;
    public static final int SDL_TRANSFER_CHARACTERISTICS_BT601 = 6;
    public static final int SDL_TRANSFER_CHARACTERISTICS_SMPTE240 = 7;
    public static final int SDL_TRANSFER_CHARACTERISTICS_LINEAR = 8;
    public static final int SDL_TRANSFER_CHARACTERISTICS_LOG100 = 9;
    public static final int SDL_TRANSFER_CHARACTERISTICS_LOG100_SQRT10 = 10;
    public static final int SDL_TRANSFER_CHARACTERISTICS_IEC61966 = 11;
    public static final int SDL_TRANSFER_CHARACTERISTICS_BT1361 = 12;
    public static final int SDL_TRANSFER_CHARACTERISTICS_SRGB = 13;
    public static final int SDL_TRANSFER_CHARACTERISTICS_BT2020_10BIT = 14;
    public static final int SDL_TRANSFER_CHARACTERISTICS_BT2020_12BIT = 15;
    public static final int SDL_TRANSFER_CHARACTERISTICS_PQ = 16;
    public static final int SDL_TRANSFER_CHARACTERISTICS_SMPTE428 = 17;
    public static final int SDL_TRANSFER_CHARACTERISTICS_HLG = 18;
    public static final int SDL_TRANSFER_CHARACTERISTICS_CUSTOM = 31;
    public static final int SDL_MATRIX_COEFFICIENTS_IDENTITY = 0;
    public static final int SDL_MATRIX_COEFFICIENTS_BT709 = 1;
    public static final int SDL_MATRIX_COEFFICIENTS_UNSPECIFIED = 2;
    public static final int SDL_MATRIX_COEFFICIENTS_FCC = 4;
    public static final int SDL_MATRIX_COEFFICIENTS_BT470BG = 5;
    public static final int SDL_MATRIX_COEFFICIENTS_BT601 = 6;
    public static final int SDL_MATRIX_COEFFICIENTS_SMPTE240 = 7;
    public static final int SDL_MATRIX_COEFFICIENTS_YCGCO = 8;
    public static final int SDL_MATRIX_COEFFICIENTS_BT2020_NCL = 9;
    public static final int SDL_MATRIX_COEFFICIENTS_BT2020_CL = 10;
    public static final int SDL_MATRIX_COEFFICIENTS_SMPTE2085 = 11;
    public static final int SDL_MATRIX_COEFFICIENTS_CHROMA_DERIVED_NCL = 12;
    public static final int SDL_MATRIX_COEFFICIENTS_CHROMA_DERIVED_CL = 13;
    public static final int SDL_MATRIX_COEFFICIENTS_ICTCP = 14;
    public static final int SDL_MATRIX_COEFFICIENTS_CUSTOM = 31;
    public static final int SDL_CHROMA_LOCATION_NONE = 0;
    public static final int SDL_CHROMA_LOCATION_LEFT = 1;
    public static final int SDL_CHROMA_LOCATION_CENTER = 2;
    public static final int SDL_CHROMA_LOCATION_TOPLEFT = 3;
    public static final int SDL_COLORSPACE_UNKNOWN = 0;
    public static final int SDL_COLORSPACE_SRGB = 301991328;
    public static final int SDL_COLORSPACE_SRGB_LINEAR = 301991168;
    public static final int SDL_COLORSPACE_HDR10 = 301999616;
    public static final int SDL_COLORSPACE_JPEG = 570426566;
    public static final int SDL_COLORSPACE_BT601_LIMITED = 554703046;
    public static final int SDL_COLORSPACE_BT601_FULL = 571480262;
    public static final int SDL_COLORSPACE_BT709_LIMITED = 554697761;
    public static final int SDL_COLORSPACE_BT709_FULL = 571474977;
    public static final int SDL_COLORSPACE_BT2020_LIMITED = 554706441;
    public static final int SDL_COLORSPACE_BT2020_FULL = 571483657;
    public static final int SDL_COLORSPACE_RGB_DEFAULT = 301991328;
    public static final int SDL_COLORSPACE_YUV_DEFAULT = 554703046;

    protected SDLPixels() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_GetPixelFormatName(int format) {
        long __functionAddress = Functions.GetPixelFormatName;
        return JNI.invokeP(format, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetPixelFormatName(@NativeType(value="SDL_PixelFormat") int format) {
        long __result = SDLPixels.nSDL_GetPixelFormatName(format);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static boolean nSDL_GetMasksForPixelFormat(int format, long bpp, long Rmask, long Gmask, long Bmask, long Amask) {
        long __functionAddress = Functions.GetMasksForPixelFormat;
        return JNI.invokePPPPPZ(format, bpp, Rmask, Gmask, Bmask, Amask, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetMasksForPixelFormat(@NativeType(value="SDL_PixelFormat") int format, @NativeType(value="int *") IntBuffer bpp, @NativeType(value="Uint32 *") IntBuffer Rmask, @NativeType(value="Uint32 *") IntBuffer Gmask, @NativeType(value="Uint32 *") IntBuffer Bmask, @NativeType(value="Uint32 *") IntBuffer Amask) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bpp, 1);
            Checks.check((Buffer)Rmask, 1);
            Checks.check((Buffer)Gmask, 1);
            Checks.check((Buffer)Bmask, 1);
            Checks.check((Buffer)Amask, 1);
        }
        return SDLPixels.nSDL_GetMasksForPixelFormat(format, MemoryUtil.memAddress(bpp), MemoryUtil.memAddress(Rmask), MemoryUtil.memAddress(Gmask), MemoryUtil.memAddress(Bmask), MemoryUtil.memAddress(Amask));
    }

    @NativeType(value="SDL_PixelFormat")
    public static int SDL_GetPixelFormatForMasks(int bpp, @NativeType(value="Uint32") int Rmask, @NativeType(value="Uint32") int Gmask, @NativeType(value="Uint32") int Bmask, @NativeType(value="Uint32") int Amask) {
        long __functionAddress = Functions.GetPixelFormatForMasks;
        return JNI.invokeI(bpp, Rmask, Gmask, Bmask, Amask, __functionAddress);
    }

    public static long nSDL_GetPixelFormatDetails(int format) {
        long __functionAddress = Functions.GetPixelFormatDetails;
        return JNI.invokeP(format, __functionAddress);
    }

    @NativeType(value="SDL_PixelFormatDetails const *")
    public static @Nullable SDL_PixelFormatDetails SDL_GetPixelFormatDetails(@NativeType(value="SDL_PixelFormat") int format) {
        long __result = SDLPixels.nSDL_GetPixelFormatDetails(format);
        return SDL_PixelFormatDetails.createSafe(__result);
    }

    public static long nSDL_CreatePalette(int ncolors) {
        long __functionAddress = Functions.CreatePalette;
        return JNI.invokeP(ncolors, __functionAddress);
    }

    @NativeType(value="SDL_Palette *")
    public static @Nullable SDL_Palette SDL_CreatePalette(int ncolors) {
        long __result = SDLPixels.nSDL_CreatePalette(ncolors);
        return SDL_Palette.createSafe(__result);
    }

    public static boolean nSDL_SetPaletteColors(long palette, long colors, int firstcolor, int ncolors) {
        long __functionAddress = Functions.SetPaletteColors;
        return JNI.invokePPZ(palette, colors, firstcolor, ncolors, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetPaletteColors(@NativeType(value="SDL_Palette *") SDL_Palette palette, @NativeType(value="SDL_Color const *") SDL_Color.Buffer colors, int firstcolor) {
        return SDLPixels.nSDL_SetPaletteColors(palette.address(), colors.address(), firstcolor, colors.remaining());
    }

    public static void nSDL_DestroyPalette(long palette) {
        long __functionAddress = Functions.DestroyPalette;
        JNI.invokePV(palette, __functionAddress);
    }

    public static void SDL_DestroyPalette(@NativeType(value="SDL_Palette *") SDL_Palette palette) {
        SDLPixels.nSDL_DestroyPalette(palette.address());
    }

    public static int nSDL_MapRGB(long format, long palette, byte r, byte g, byte b) {
        long __functionAddress = Functions.MapRGB;
        return JNI.invokePPUUUI(format, palette, r, g, b, __functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_MapRGB(@NativeType(value="SDL_PixelFormatDetails const *") SDL_PixelFormatDetails format, @NativeType(value="SDL_Palette const *") @Nullable SDL_Palette palette, @NativeType(value="Uint8") byte r, @NativeType(value="Uint8") byte g, @NativeType(value="Uint8") byte b) {
        return SDLPixels.nSDL_MapRGB(format.address(), MemoryUtil.memAddressSafe(palette), r, g, b);
    }

    public static int nSDL_MapRGBA(long format, long palette, byte r, byte g, byte b, byte a) {
        long __functionAddress = Functions.MapRGBA;
        return JNI.invokePPUUUUI(format, palette, r, g, b, a, __functionAddress);
    }

    @NativeType(value="Uint32")
    public static int SDL_MapRGBA(@NativeType(value="SDL_PixelFormatDetails const *") SDL_PixelFormatDetails format, @NativeType(value="SDL_Palette const *") @Nullable SDL_Palette palette, @NativeType(value="Uint8") byte r, @NativeType(value="Uint8") byte g, @NativeType(value="Uint8") byte b, @NativeType(value="Uint8") byte a) {
        return SDLPixels.nSDL_MapRGBA(format.address(), MemoryUtil.memAddressSafe(palette), r, g, b, a);
    }

    public static void nSDL_GetRGB(int pixel, long format, long palette, long r, long g, long b) {
        long __functionAddress = Functions.GetRGB;
        JNI.invokePPPPPV(pixel, format, palette, r, g, b, __functionAddress);
    }

    public static void SDL_GetRGB(@NativeType(value="Uint32") int pixel, @NativeType(value="SDL_PixelFormatDetails const *") SDL_PixelFormatDetails format, @NativeType(value="SDL_Palette const *") @Nullable SDL_Palette palette, @NativeType(value="Uint8 *") @Nullable ByteBuffer r, @NativeType(value="Uint8 *") @Nullable ByteBuffer g, @NativeType(value="Uint8 *") @Nullable ByteBuffer b) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, 1);
            Checks.checkSafe((Buffer)g, 1);
            Checks.checkSafe((Buffer)b, 1);
        }
        SDLPixels.nSDL_GetRGB(pixel, format.address(), MemoryUtil.memAddressSafe(palette), MemoryUtil.memAddressSafe(r), MemoryUtil.memAddressSafe(g), MemoryUtil.memAddressSafe(b));
    }

    public static void nSDL_GetRGBA(int pixel, long format, long palette, long r, long g, long b, long a) {
        long __functionAddress = Functions.GetRGBA;
        JNI.invokePPPPPPV(pixel, format, palette, r, g, b, a, __functionAddress);
    }

    public static void SDL_GetRGBA(@NativeType(value="Uint32") int pixel, @NativeType(value="SDL_PixelFormatDetails const *") SDL_PixelFormatDetails format, @NativeType(value="SDL_Palette const *") @Nullable SDL_Palette palette, @NativeType(value="Uint8 *") @Nullable ByteBuffer r, @NativeType(value="Uint8 *") @Nullable ByteBuffer g, @NativeType(value="Uint8 *") @Nullable ByteBuffer b, @NativeType(value="Uint8 *") @Nullable ByteBuffer a) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, 1);
            Checks.checkSafe((Buffer)g, 1);
            Checks.checkSafe((Buffer)b, 1);
            Checks.checkSafe((Buffer)a, 1);
        }
        SDLPixels.nSDL_GetRGBA(pixel, format.address(), MemoryUtil.memAddressSafe(palette), MemoryUtil.memAddressSafe(r), MemoryUtil.memAddressSafe(g), MemoryUtil.memAddressSafe(b), MemoryUtil.memAddressSafe(a));
    }

    @NativeType(value="uint32_t")
    public static int SDL_DEFINE_PIXELFOURCC(@NativeType(value="uint8_t") byte A, @NativeType(value="uint8_t") byte B, @NativeType(value="uint8_t") byte C, @NativeType(value="uint8_t") byte D) {
        return SDLStdinc.SDL_FOURCC(A, B, C, D);
    }

    @NativeType(value="SDL_PixelFormat")
    public static int SDL_DEFINE_PIXELFORMAT(@NativeType(value="SDL_PixelType") int type, @NativeType(value="SDL_BitmapOrder") int order, @NativeType(value="SDL_PackedLayout") int layout, @NativeType(value="uint32_t") int bits, @NativeType(value="uint32_t") int bytes) {
        return 0x10000000 | type << 24 | order << 20 | layout << 16 | (bits & 0xFF) << 8 | (bytes & 0xFF) << 0;
    }

    @NativeType(value="uint32_t")
    public static int SDL_PIXELFLAG(@NativeType(value="SDL_PixelFormat") int format) {
        return format >> 28 & 0xF;
    }

    @NativeType(value="SDL_PixelType")
    public static int SDL_PIXELTYPE(@NativeType(value="SDL_PixelFormat") int format) {
        return format >> 24 & 0xF;
    }

    @NativeType(value="SDL_BitmapOrder")
    public static int SDL_PIXELORDER(@NativeType(value="SDL_PixelFormat") int format) {
        return format >> 20 & 0xF;
    }

    @NativeType(value="SDL_PackedLayout")
    public static int SDL_PIXELLAYOUT(@NativeType(value="SDL_PixelFormat") int format) {
        return format >> 16 & 0xF;
    }

    @NativeType(value="uint32_t")
    public static int SDL_BITSPERPIXEL(@NativeType(value="SDL_PixelFormat") int format) {
        return SDLPixels.SDL_ISPIXELFORMAT_FOURCC(format) ? 0 : format >> 8 & 0xFF;
    }

    @NativeType(value="uint32_t")
    public static int SDL_BYTESPERPIXEL(@NativeType(value="SDL_PixelFormat") int format) {
        return SDLPixels.SDL_ISPIXELFORMAT_FOURCC(format) ? (format == 844715353 || format == 0x59565955 || format == 0x55595659 || format == 808530000 ? 2 : 1) : format >> 0 & 0xFF;
    }

    @NativeType(value="bool")
    public static boolean SDL_ISPIXELFORMAT_INDEXED(@NativeType(value="SDL_PixelFormat") int format) {
        return !SDLPixels.SDL_ISPIXELFORMAT_FOURCC(format) && (SDLPixels.SDL_PIXELTYPE(format) == 1 || SDLPixels.SDL_PIXELTYPE(format) == 12 || SDLPixels.SDL_PIXELTYPE(format) == 2 || SDLPixels.SDL_PIXELTYPE(format) == 3);
    }

    @NativeType(value="bool")
    public static boolean SDL_ISPIXELFORMAT_PACKED(@NativeType(value="SDL_PixelFormat") int format) {
        return !SDLPixels.SDL_ISPIXELFORMAT_FOURCC(format) && (SDLPixels.SDL_PIXELTYPE(format) == 4 || SDLPixels.SDL_PIXELTYPE(format) == 5 || SDLPixels.SDL_PIXELTYPE(format) == 6);
    }

    @NativeType(value="bool")
    public static boolean SDL_ISPIXELFORMAT_ARRAY(@NativeType(value="SDL_PixelFormat") int format) {
        return !SDLPixels.SDL_ISPIXELFORMAT_FOURCC(format) && (SDLPixels.SDL_PIXELTYPE(format) == 7 || SDLPixels.SDL_PIXELTYPE(format) == 8 || SDLPixels.SDL_PIXELTYPE(format) == 9 || SDLPixels.SDL_PIXELTYPE(format) == 10 || SDLPixels.SDL_PIXELTYPE(format) == 11);
    }

    @NativeType(value="bool")
    public static boolean SDL_ISPIXELFORMAT_10BIT(@NativeType(value="SDL_PixelFormat") int format) {
        return !SDLPixels.SDL_ISPIXELFORMAT_FOURCC(format) && SDLPixels.SDL_PIXELTYPE(format) == 6 && SDLPixels.SDL_PIXELLAYOUT(format) == 7;
    }

    @NativeType(value="bool")
    public static boolean SDL_ISPIXELFORMAT_FLOAT(@NativeType(value="SDL_PixelFormat") int format) {
        return !SDLPixels.SDL_ISPIXELFORMAT_FOURCC(format) && (SDLPixels.SDL_PIXELTYPE(format) == 10 || SDLPixels.SDL_PIXELTYPE(format) == 11);
    }

    @NativeType(value="bool")
    public static boolean SDL_ISPIXELFORMAT_ALPHA(@NativeType(value="SDL_PixelFormat") int format) {
        return SDLPixels.SDL_ISPIXELFORMAT_PACKED(format) && (SDLPixels.SDL_PIXELORDER(format) == 3 || SDLPixels.SDL_PIXELORDER(format) == 4 || SDLPixels.SDL_PIXELORDER(format) == 7 || SDLPixels.SDL_PIXELORDER(format) == 8) || SDLPixels.SDL_ISPIXELFORMAT_ARRAY(format) && (SDLPixels.SDL_PIXELORDER(format) == 3 || SDLPixels.SDL_PIXELORDER(format) == 2 || SDLPixels.SDL_PIXELORDER(format) == 6 || SDLPixels.SDL_PIXELORDER(format) == 5);
    }

    @NativeType(value="bool")
    public static boolean SDL_ISPIXELFORMAT_FOURCC(@NativeType(value="SDL_PixelFormat") int format) {
        return format != 0 && SDLPixels.SDL_PIXELFLAG(format) != 1;
    }

    @NativeType(value="SDL_Colorspace")
    public static int SDL_DEFINE_COLORSPACE(@NativeType(value="SDL_ColorType") int type, @NativeType(value="SDL_ColorRange") int range, @NativeType(value="SDL_ColorPrimaries") int primaries, @NativeType(value="SDL_TransferCharacteristics") int transfer, @NativeType(value="SDL_MatrixCoefficients") int matrix, @NativeType(value="SDL_ChromaLocation") int chroma) {
        return type << 28 | range << 24 | chroma << 20 | primaries << 10 | transfer << 5 | matrix << 0;
    }

    @NativeType(value="SDL_ColorType")
    public static int SDL_COLORSPACETYPE(@NativeType(value="SDL_Colorspace") int cspace) {
        return cspace >> 28 & 0xF;
    }

    @NativeType(value="SDL_ColorRange")
    public static int SDL_COLORSPACERANGE(@NativeType(value="SDL_Colorspace") int cspace) {
        return cspace >> 24 & 0xF;
    }

    @NativeType(value="SDL_ChromaLocation")
    public static int SDL_COLORSPACECHROMA(@NativeType(value="SDL_Colorspace") int cspace) {
        return cspace >> 20 & 0xF;
    }

    @NativeType(value="SDL_ColorPrimaries")
    public static int SDL_COLORSPACEPRIMARIES(@NativeType(value="SDL_Colorspace") int cspace) {
        return cspace >> 10 & 0x1F;
    }

    @NativeType(value="SDL_TransferCharacteristics")
    public static int SDL_COLORSPACETRANSFER(@NativeType(value="SDL_Colorspace") int cspace) {
        return cspace >> 5 & 0x1F;
    }

    @NativeType(value="SDL_MatrixCoefficients")
    public static int SDL_COLORSPACEMATRIX(@NativeType(value="SDL_Colorspace") int cspace) {
        return cspace & 0x1F;
    }

    @NativeType(value="bool")
    public static boolean SDL_ISCOLORSPACE_MATRIX_BT601(@NativeType(value="SDL_Colorspace") int cspace) {
        return SDLPixels.SDL_COLORSPACEMATRIX(cspace) == 6 || SDLPixels.SDL_COLORSPACEMATRIX(cspace) == 5;
    }

    @NativeType(value="bool")
    public static boolean SDL_ISCOLORSPACE_MATRIX_BT709(@NativeType(value="SDL_Colorspace") int cspace) {
        return SDLPixels.SDL_COLORSPACEMATRIX(cspace) == 1;
    }

    @NativeType(value="bool")
    public static boolean SDL_ISCOLORSPACE_MATRIX_BT2020_NCL(@NativeType(value="SDL_Colorspace") int cspace) {
        return SDLPixels.SDL_COLORSPACEMATRIX(cspace) == 9;
    }

    @NativeType(value="bool")
    public static boolean SDL_ISCOLORSPACE_LIMITED_RANGE(@NativeType(value="SDL_Colorspace") int cspace) {
        return SDLPixels.SDL_COLORSPACERANGE(cspace) != 2;
    }

    @NativeType(value="bool")
    public static boolean SDL_ISCOLORSPACE_FULL_RANGE(@NativeType(value="SDL_Colorspace") int cspace) {
        return SDLPixels.SDL_COLORSPACERANGE(cspace) == 2;
    }

    public static final class Functions {
        public static final long GetPixelFormatName = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetPixelFormatName");
        public static final long GetMasksForPixelFormat = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetMasksForPixelFormat");
        public static final long GetPixelFormatForMasks = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetPixelFormatForMasks");
        public static final long GetPixelFormatDetails = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetPixelFormatDetails");
        public static final long CreatePalette = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreatePalette");
        public static final long SetPaletteColors = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetPaletteColors");
        public static final long DestroyPalette = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_DestroyPalette");
        public static final long MapRGB = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_MapRGB");
        public static final long MapRGBA = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_MapRGBA");
        public static final long GetRGB = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetRGB");
        public static final long GetRGBA = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetRGBA");

        private Functions() {
        }
    }
}

