/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLPower {
    public static final int SDL_POWERSTATE_ERROR = -1;
    public static final int SDL_POWERSTATE_UNKNOWN = 0;
    public static final int SDL_POWERSTATE_ON_BATTERY = 1;
    public static final int SDL_POWERSTATE_NO_BATTERY = 2;
    public static final int SDL_POWERSTATE_CHARGING = 3;
    public static final int SDL_POWERSTATE_CHARGED = 4;

    protected SDLPower() {
        throw new UnsupportedOperationException();
    }

    public static int nSDL_GetPowerInfo(long seconds, long percent) {
        long __functionAddress = Functions.GetPowerInfo;
        return JNI.invokePPI(seconds, percent, __functionAddress);
    }

    @NativeType(value="SDL_PowerState")
    public static int SDL_GetPowerInfo(@NativeType(value="int *") @Nullable IntBuffer seconds, @NativeType(value="int *") @Nullable IntBuffer percent) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)seconds, 1);
            Checks.checkSafe((Buffer)percent, 1);
        }
        return SDLPower.nSDL_GetPowerInfo(MemoryUtil.memAddressSafe(seconds), MemoryUtil.memAddressSafe(percent));
    }

    public static final class Functions {
        public static final long GetPowerInfo = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetPowerInfo");

        private Functions() {
        }
    }
}

