/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_EnumerateDirectoryCallbackI;
import org.lwjgl.sdl.SDL_PathInfo;
import org.lwjgl.sdl.SDL_StorageInterface;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLStorage {
    protected SDLStorage() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_OpenTitleStorage(long override, int props) {
        long __functionAddress = Functions.OpenTitleStorage;
        return JNI.invokePP(override, props, __functionAddress);
    }

    @NativeType(value="SDL_Storage *")
    public static long SDL_OpenTitleStorage(@NativeType(value="char const *") @Nullable ByteBuffer override, @NativeType(value="SDL_PropertiesID") int props) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(override);
        }
        return SDLStorage.nSDL_OpenTitleStorage(MemoryUtil.memAddressSafe(override), props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Storage *")
    public static long SDL_OpenTitleStorage(@NativeType(value="char const *") @Nullable CharSequence override, @NativeType(value="SDL_PropertiesID") int props) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(override, true);
            long overrideEncoded = override == null ? 0L : stack.getPointerAddress();
            long l = SDLStorage.nSDL_OpenTitleStorage(overrideEncoded, props);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_OpenUserStorage(long org, long app, int props) {
        long __functionAddress = Functions.OpenUserStorage;
        return JNI.invokePPP(org, app, props, __functionAddress);
    }

    @NativeType(value="SDL_Storage *")
    public static long SDL_OpenUserStorage(@NativeType(value="char const *") ByteBuffer org, @NativeType(value="char const *") ByteBuffer app, @NativeType(value="SDL_PropertiesID") int props) {
        if (Checks.CHECKS) {
            Checks.checkNT1(org);
            Checks.checkNT1(app);
        }
        return SDLStorage.nSDL_OpenUserStorage(MemoryUtil.memAddress(org), MemoryUtil.memAddress(app), props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Storage *")
    public static long SDL_OpenUserStorage(@NativeType(value="char const *") CharSequence org, @NativeType(value="char const *") CharSequence app, @NativeType(value="SDL_PropertiesID") int props) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(org, true);
            long orgEncoded = stack.getPointerAddress();
            stack.nUTF8(app, true);
            long appEncoded = stack.getPointerAddress();
            long l = SDLStorage.nSDL_OpenUserStorage(orgEncoded, appEncoded, props);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_OpenFileStorage(long path) {
        long __functionAddress = Functions.OpenFileStorage;
        return JNI.invokePP(path, __functionAddress);
    }

    @NativeType(value="SDL_Storage *")
    public static long SDL_OpenFileStorage(@NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return SDLStorage.nSDL_OpenFileStorage(MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Storage *")
    public static long SDL_OpenFileStorage(@NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = SDLStorage.nSDL_OpenFileStorage(pathEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_OpenStorage(long iface, long userdata) {
        long __functionAddress = Functions.OpenStorage;
        return JNI.invokePPP(iface, userdata, __functionAddress);
    }

    @NativeType(value="SDL_Storage *")
    public static long SDL_OpenStorage(@NativeType(value="SDL_StorageInterface const *") SDL_StorageInterface iface, @NativeType(value="void *") long userdata) {
        return SDLStorage.nSDL_OpenStorage(iface.address(), userdata);
    }

    @NativeType(value="bool")
    public static boolean SDL_CloseStorage(@NativeType(value="SDL_Storage *") long storage) {
        long __functionAddress = Functions.CloseStorage;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePZ(storage, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_StorageReady(@NativeType(value="SDL_Storage *") long storage) {
        long __functionAddress = Functions.StorageReady;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePZ(storage, __functionAddress);
    }

    public static boolean nSDL_GetStorageFileSize(long storage, long path, long length) {
        long __functionAddress = Functions.GetStorageFileSize;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPPZ(storage, path, length, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetStorageFileSize(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="Uint64 *") @Nullable LongBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
            Checks.checkSafe((Buffer)length, 1);
        }
        return SDLStorage.nSDL_GetStorageFileSize(storage, MemoryUtil.memAddress(path), MemoryUtil.memAddressSafe(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_GetStorageFileSize(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") CharSequence path, @NativeType(value="Uint64 *") @Nullable LongBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_GetStorageFileSize(storage, pathEncoded, MemoryUtil.memAddressSafe(length));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_ReadStorageFile(long storage, long path, long destination, long length) {
        long __functionAddress = Functions.ReadStorageFile;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPPJZ(storage, path, destination, length, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ReadStorageFile(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="void *") ByteBuffer destination) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return SDLStorage.nSDL_ReadStorageFile(storage, MemoryUtil.memAddress(path), MemoryUtil.memAddress(destination), destination.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_ReadStorageFile(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") CharSequence path, @NativeType(value="void *") ByteBuffer destination) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_ReadStorageFile(storage, pathEncoded, MemoryUtil.memAddress(destination), destination.remaining());
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_WriteStorageFile(long storage, long path, long source, long length) {
        long __functionAddress = Functions.WriteStorageFile;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPPJZ(storage, path, source, length, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_WriteStorageFile(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="void const *") ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return SDLStorage.nSDL_WriteStorageFile(storage, MemoryUtil.memAddress(path), MemoryUtil.memAddress(source), source.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_WriteStorageFile(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") CharSequence path, @NativeType(value="void const *") ByteBuffer source) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_WriteStorageFile(storage, pathEncoded, MemoryUtil.memAddress(source), source.remaining());
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_CreateStorageDirectory(long storage, long path) {
        long __functionAddress = Functions.CreateStorageDirectory;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPZ(storage, path, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_CreateStorageDirectory(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return SDLStorage.nSDL_CreateStorageDirectory(storage, MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_CreateStorageDirectory(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_CreateStorageDirectory(storage, pathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_EnumerateStorageDirectory(long storage, long path, long callback, long userdata) {
        long __functionAddress = Functions.EnumerateStorageDirectory;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPPPZ(storage, path, callback, userdata, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_EnumerateStorageDirectory(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") @Nullable ByteBuffer path, @NativeType(value="SDL_EnumerateDirectoryCallback") SDL_EnumerateDirectoryCallbackI callback, @NativeType(value="void *") long userdata) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(path);
        }
        return SDLStorage.nSDL_EnumerateStorageDirectory(storage, MemoryUtil.memAddressSafe(path), callback.address(), userdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_EnumerateStorageDirectory(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") @Nullable CharSequence path, @NativeType(value="SDL_EnumerateDirectoryCallback") SDL_EnumerateDirectoryCallbackI callback, @NativeType(value="void *") long userdata) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(path, true);
            long pathEncoded = path == null ? 0L : stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_EnumerateStorageDirectory(storage, pathEncoded, callback.address(), userdata);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_RemoveStoragePath(long storage, long path) {
        long __functionAddress = Functions.RemoveStoragePath;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPZ(storage, path, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RemoveStoragePath(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return SDLStorage.nSDL_RemoveStoragePath(storage, MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_RemoveStoragePath(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_RemoveStoragePath(storage, pathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_RenameStoragePath(long storage, long oldpath, long newpath) {
        long __functionAddress = Functions.RenameStoragePath;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPPZ(storage, oldpath, newpath, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenameStoragePath(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") ByteBuffer oldpath, @NativeType(value="char const *") ByteBuffer newpath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(oldpath);
            Checks.checkNT1(newpath);
        }
        return SDLStorage.nSDL_RenameStoragePath(storage, MemoryUtil.memAddress(oldpath), MemoryUtil.memAddress(newpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_RenameStoragePath(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") CharSequence oldpath, @NativeType(value="char const *") CharSequence newpath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(oldpath, true);
            long oldpathEncoded = stack.getPointerAddress();
            stack.nUTF8(newpath, true);
            long newpathEncoded = stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_RenameStoragePath(storage, oldpathEncoded, newpathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_CopyStorageFile(long storage, long oldpath, long newpath) {
        long __functionAddress = Functions.CopyStorageFile;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPPZ(storage, oldpath, newpath, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_CopyStorageFile(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") ByteBuffer oldpath, @NativeType(value="char const *") ByteBuffer newpath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(oldpath);
            Checks.checkNT1(newpath);
        }
        return SDLStorage.nSDL_CopyStorageFile(storage, MemoryUtil.memAddress(oldpath), MemoryUtil.memAddress(newpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_CopyStorageFile(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") CharSequence oldpath, @NativeType(value="char const *") CharSequence newpath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(oldpath, true);
            long oldpathEncoded = stack.getPointerAddress();
            stack.nUTF8(newpath, true);
            long newpathEncoded = stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_CopyStorageFile(storage, oldpathEncoded, newpathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_GetStoragePathInfo(long storage, long path, long info) {
        long __functionAddress = Functions.GetStoragePathInfo;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPPZ(storage, path, info, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetStoragePathInfo(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="SDL_PathInfo *") @Nullable SDL_PathInfo info) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return SDLStorage.nSDL_GetStoragePathInfo(storage, MemoryUtil.memAddress(path), MemoryUtil.memAddressSafe(info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_GetStoragePathInfo(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") CharSequence path, @NativeType(value="SDL_PathInfo *") @Nullable SDL_PathInfo info) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = SDLStorage.nSDL_GetStoragePathInfo(storage, pathEncoded, MemoryUtil.memAddressSafe(info));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="Uint64")
    public static long SDL_GetStorageSpaceRemaining(@NativeType(value="SDL_Storage *") long storage) {
        long __functionAddress = Functions.GetStorageSpaceRemaining;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePJ(storage, __functionAddress);
    }

    public static long nSDL_GlobStorageDirectory(long storage, long path, long pattern, int flags, long count) {
        long __functionAddress = Functions.GlobStorageDirectory;
        if (Checks.CHECKS) {
            Checks.check(storage);
        }
        return JNI.invokePPPPP(storage, path, pattern, flags, count, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char **")
    public static @Nullable PointerBuffer SDL_GlobStorageDirectory(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") @Nullable ByteBuffer path, @NativeType(value="char const *") @Nullable ByteBuffer pattern, @NativeType(value="SDL_GlobFlags") int flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(path);
            Checks.checkNT1Safe(pattern);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLStorage.nSDL_GlobStorageDirectory(storage, MemoryUtil.memAddressSafe(path), MemoryUtil.memAddressSafe(pattern), flags, MemoryUtil.memAddress(count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(__result, count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char **")
    public static @Nullable PointerBuffer SDL_GlobStorageDirectory(@NativeType(value="SDL_Storage *") long storage, @NativeType(value="char const *") @Nullable CharSequence path, @NativeType(value="char const *") @Nullable CharSequence pattern, @NativeType(value="SDL_GlobFlags") int flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer count = stack.callocInt(1);
            stack.nUTF8Safe(path, true);
            long pathEncoded = path == null ? 0L : stack.getPointerAddress();
            stack.nUTF8Safe(pattern, true);
            long patternEncoded = pattern == null ? 0L : stack.getPointerAddress();
            long __result = SDLStorage.nSDL_GlobStorageDirectory(storage, pathEncoded, patternEncoded, flags, MemoryUtil.memAddress(count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(__result, count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void SDL_INIT_INTERFACE(SDL_StorageInterface iface) {
        iface.clear();
        iface.version(SDL_StorageInterface.SIZEOF);
    }

    public static final class Functions {
        public static final long OpenTitleStorage = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_OpenTitleStorage");
        public static final long OpenUserStorage = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_OpenUserStorage");
        public static final long OpenFileStorage = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_OpenFileStorage");
        public static final long OpenStorage = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_OpenStorage");
        public static final long CloseStorage = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CloseStorage");
        public static final long StorageReady = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_StorageReady");
        public static final long GetStorageFileSize = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetStorageFileSize");
        public static final long ReadStorageFile = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ReadStorageFile");
        public static final long WriteStorageFile = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_WriteStorageFile");
        public static final long CreateStorageDirectory = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateStorageDirectory");
        public static final long EnumerateStorageDirectory = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_EnumerateStorageDirectory");
        public static final long RemoveStoragePath = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_RemoveStoragePath");
        public static final long RenameStoragePath = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_RenameStoragePath");
        public static final long CopyStorageFile = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CopyStorageFile");
        public static final long GetStoragePathInfo = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetStoragePathInfo");
        public static final long GetStorageSpaceRemaining = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetStorageSpaceRemaining");
        public static final long GlobStorageDirectory = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GlobStorageDirectory");

        private Functions() {
        }
    }
}

