/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_WindowsMessageHookI;
import org.lwjgl.sdl.SDL_X11EventHookI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLSystem {
    public static final int SDL_SANDBOX_NONE = 0;
    public static final int SDL_SANDBOX_UNKNOWN_CONTAINER = 1;
    public static final int SDL_SANDBOX_FLATPAK = 2;
    public static final int SDL_SANDBOX_SNAP = 3;
    public static final int SDL_SANDBOX_MACOS = 4;

    protected SDLSystem() {
        throw new UnsupportedOperationException();
    }

    public static void nSDL_SetWindowsMessageHook(long callback, long userdata) {
        long __functionAddress = Functions.SetWindowsMessageHook;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.invokePPV(callback, userdata, __functionAddress);
    }

    public static void SDL_SetWindowsMessageHook(@NativeType(value="SDL_WindowsMessageHook") @Nullable SDL_WindowsMessageHookI callback, @NativeType(value="void *") long userdata) {
        SDLSystem.nSDL_SetWindowsMessageHook(MemoryUtil.memAddressSafe(callback), userdata);
    }

    public static int SDL_GetDirect3D9AdapterIndex(@NativeType(value="SDL_DisplayID") int displayID) {
        long __functionAddress = Functions.GetDirect3D9AdapterIndex;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeI(displayID, __functionAddress);
    }

    public static boolean nSDL_GetDXGIOutputInfo(int displayID, long adapterIndex, long outputIndex) {
        long __functionAddress = Functions.GetDXGIOutputInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePPZ(displayID, adapterIndex, outputIndex, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetDXGIOutputInfo(@NativeType(value="SDL_DisplayID") int displayID, @NativeType(value="int *") IntBuffer adapterIndex, @NativeType(value="int *") IntBuffer outputIndex) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)adapterIndex, 1);
            Checks.check((Buffer)outputIndex, 1);
        }
        return SDLSystem.nSDL_GetDXGIOutputInfo(displayID, MemoryUtil.memAddress(adapterIndex), MemoryUtil.memAddress(outputIndex));
    }

    public static void nSDL_SetX11EventHook(long callback, long userdata) {
        long __functionAddress = Functions.SetX11EventHook;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.invokePPV(callback, userdata, __functionAddress);
    }

    public static void SDL_SetX11EventHook(@NativeType(value="SDL_X11EventHook") @Nullable SDL_X11EventHookI callback, @NativeType(value="void *") long userdata) {
        SDLSystem.nSDL_SetX11EventHook(MemoryUtil.memAddressSafe(callback), userdata);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetLinuxThreadPriority(@NativeType(value="Sint64") long threadID, int priority) {
        long __functionAddress = Functions.SetLinuxThreadPriority;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeJZ(threadID, priority, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetLinuxThreadPriorityAndPolicy(@NativeType(value="Sint64") long threadID, int sdlPriority, int schedPolicy) {
        long __functionAddress = Functions.SetLinuxThreadPriorityAndPolicy;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeJZ(threadID, sdlPriority, schedPolicy, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsTablet() {
        long __functionAddress = Functions.IsTablet;
        return JNI.invokeZ(__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsTV() {
        long __functionAddress = Functions.IsTV;
        return JNI.invokeZ(__functionAddress);
    }

    @NativeType(value="SDL_Sandbox")
    public static int SDL_GetSandbox() {
        long __functionAddress = Functions.GetSandbox;
        return JNI.invokeI(__functionAddress);
    }

    public static final class Functions {
        public static final long SetWindowsMessageHook = APIUtil.apiGetFunctionAddressOptional(SDL.getLibrary(), "SDL_SetWindowsMessageHook");
        public static final long GetDirect3D9AdapterIndex = APIUtil.apiGetFunctionAddressOptional(SDL.getLibrary(), "SDL_GetDirect3D9AdapterIndex");
        public static final long GetDXGIOutputInfo = APIUtil.apiGetFunctionAddressOptional(SDL.getLibrary(), "SDL_GetDXGIOutputInfo");
        public static final long SetX11EventHook = APIUtil.apiGetFunctionAddressOptional(SDL.getLibrary(), "SDL_SetX11EventHook");
        public static final long SetLinuxThreadPriority = APIUtil.apiGetFunctionAddressOptional(SDL.getLibrary(), "SDL_SetLinuxThreadPriority");
        public static final long SetLinuxThreadPriorityAndPolicy = APIUtil.apiGetFunctionAddressOptional(SDL.getLibrary(), "SDL_SetLinuxThreadPriorityAndPolicy");
        public static final long IsTablet = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_IsTablet");
        public static final long IsTV = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_IsTV");
        public static final long GetSandbox = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetSandbox");

        private Functions() {
        }
    }
}

