/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.sdl.SDL_TrayCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLTray {
    public static final int SDL_TRAYENTRY_BUTTON = 1;
    public static final int SDL_TRAYENTRY_CHECKBOX = 2;
    public static final int SDL_TRAYENTRY_SUBMENU = 4;
    public static final int SDL_TRAYENTRY_DISABLED = Integer.MIN_VALUE;
    public static final int SDL_TRAYENTRY_CHECKED = 0x40000000;

    protected SDLTray() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_CreateTray(long icon, long tooltip) {
        long __functionAddress = Functions.CreateTray;
        return JNI.invokePPP(icon, tooltip, __functionAddress);
    }

    @NativeType(value="SDL_Tray *")
    public static long SDL_CreateTray(@NativeType(value="SDL_Surface *") @Nullable SDL_Surface.Buffer icon, @NativeType(value="char const *") @Nullable ByteBuffer tooltip) {
        if (Checks.CHECKS) {
            Checks.checkSafe(icon, 1);
            Checks.checkNT1Safe(tooltip);
        }
        return SDLTray.nSDL_CreateTray(MemoryUtil.memAddressSafe(icon), MemoryUtil.memAddressSafe(tooltip));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Tray *")
    public static long SDL_CreateTray(@NativeType(value="SDL_Surface *") @Nullable SDL_Surface.Buffer icon, @NativeType(value="char const *") @Nullable CharSequence tooltip) {
        if (Checks.CHECKS) {
            Checks.checkSafe(icon, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(tooltip, true);
            long tooltipEncoded = tooltip == null ? 0L : stack.getPointerAddress();
            long l = SDLTray.nSDL_CreateTray(MemoryUtil.memAddressSafe(icon), tooltipEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nSDL_SetTrayIcon(long tray, long icon) {
        long __functionAddress = Functions.SetTrayIcon;
        if (Checks.CHECKS) {
            Checks.check(tray);
        }
        JNI.invokePPV(tray, icon, __functionAddress);
    }

    public static void SDL_SetTrayIcon(@NativeType(value="SDL_Tray *") long tray, @NativeType(value="SDL_Surface *") @Nullable SDL_Surface icon) {
        SDLTray.nSDL_SetTrayIcon(tray, MemoryUtil.memAddressSafe(icon));
    }

    public static void nSDL_SetTrayTooltip(long tray, long tooltip) {
        long __functionAddress = Functions.SetTrayTooltip;
        if (Checks.CHECKS) {
            Checks.check(tray);
        }
        JNI.invokePPV(tray, tooltip, __functionAddress);
    }

    public static void SDL_SetTrayTooltip(@NativeType(value="SDL_Tray *") long tray, @NativeType(value="char const *") @Nullable ByteBuffer tooltip) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(tooltip);
        }
        SDLTray.nSDL_SetTrayTooltip(tray, MemoryUtil.memAddressSafe(tooltip));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SDL_SetTrayTooltip(@NativeType(value="SDL_Tray *") long tray, @NativeType(value="char const *") @Nullable CharSequence tooltip) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(tooltip, true);
            long tooltipEncoded = tooltip == null ? 0L : stack.getPointerAddress();
            SDLTray.nSDL_SetTrayTooltip(tray, tooltipEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="SDL_TrayMenu *")
    public static long SDL_CreateTrayMenu(@NativeType(value="SDL_Tray *") long tray) {
        long __functionAddress = Functions.CreateTrayMenu;
        if (Checks.CHECKS) {
            Checks.check(tray);
        }
        return JNI.invokePP(tray, __functionAddress);
    }

    @NativeType(value="SDL_TrayMenu *")
    public static long SDL_CreateTraySubmenu(@NativeType(value="SDL_TrayEntry *") long entry) {
        long __functionAddress = Functions.CreateTraySubmenu;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        return JNI.invokePP(entry, __functionAddress);
    }

    @NativeType(value="SDL_TrayMenu *")
    public static long SDL_GetTrayMenu(@NativeType(value="SDL_Tray *") long tray) {
        long __functionAddress = Functions.GetTrayMenu;
        if (Checks.CHECKS) {
            Checks.check(tray);
        }
        return JNI.invokePP(tray, __functionAddress);
    }

    @NativeType(value="SDL_TrayMenu *")
    public static long SDL_GetTraySubmenu(@NativeType(value="SDL_TrayEntry *") long entry) {
        long __functionAddress = Functions.GetTraySubmenu;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        return JNI.invokePP(entry, __functionAddress);
    }

    public static long nSDL_GetTrayEntries(long menu, long count) {
        long __functionAddress = Functions.GetTrayEntries;
        if (Checks.CHECKS) {
            Checks.check(menu);
        }
        return JNI.invokePPP(menu, count, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_TrayEntry const **")
    public static @Nullable PointerBuffer SDL_GetTrayEntries(@NativeType(value="SDL_TrayMenu *") long menu) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLTray.nSDL_GetTrayEntries(menu, MemoryUtil.memAddress(count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(__result, count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void SDL_RemoveTrayEntry(@NativeType(value="SDL_TrayEntry *") long entry) {
        long __functionAddress = Functions.RemoveTrayEntry;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        JNI.invokePV(entry, __functionAddress);
    }

    public static long nSDL_InsertTrayEntryAt(long menu, int pos, long label, int flags) {
        long __functionAddress = Functions.InsertTrayEntryAt;
        if (Checks.CHECKS) {
            Checks.check(menu);
        }
        return JNI.invokePPP(menu, pos, label, flags, __functionAddress);
    }

    @NativeType(value="SDL_TrayEntry *")
    public static long SDL_InsertTrayEntryAt(@NativeType(value="SDL_TrayMenu *") long menu, int pos, @NativeType(value="char const *") @Nullable ByteBuffer label, @NativeType(value="SDL_TrayEntryFlags") int flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(label);
        }
        return SDLTray.nSDL_InsertTrayEntryAt(menu, pos, MemoryUtil.memAddressSafe(label), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_TrayEntry *")
    public static long SDL_InsertTrayEntryAt(@NativeType(value="SDL_TrayMenu *") long menu, int pos, @NativeType(value="char const *") @Nullable CharSequence label, @NativeType(value="SDL_TrayEntryFlags") int flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(label, true);
            long labelEncoded = label == null ? 0L : stack.getPointerAddress();
            long l = SDLTray.nSDL_InsertTrayEntryAt(menu, pos, labelEncoded, flags);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nSDL_SetTrayEntryLabel(long entry, long label) {
        long __functionAddress = Functions.SetTrayEntryLabel;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        JNI.invokePPV(entry, label, __functionAddress);
    }

    public static void SDL_SetTrayEntryLabel(@NativeType(value="SDL_TrayEntry *") long entry, @NativeType(value="char const *") @Nullable ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(label);
        }
        SDLTray.nSDL_SetTrayEntryLabel(entry, MemoryUtil.memAddressSafe(label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SDL_SetTrayEntryLabel(@NativeType(value="SDL_TrayEntry *") long entry, @NativeType(value="char const *") @Nullable CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(label, true);
            long labelEncoded = label == null ? 0L : stack.getPointerAddress();
            SDLTray.nSDL_SetTrayEntryLabel(entry, labelEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetTrayEntryLabel(long entry) {
        long __functionAddress = Functions.GetTrayEntryLabel;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        return JNI.invokePP(entry, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetTrayEntryLabel(@NativeType(value="SDL_TrayEntry *") long entry) {
        long __result = SDLTray.nSDL_GetTrayEntryLabel(entry);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static void SDL_SetTrayEntryChecked(@NativeType(value="SDL_TrayEntry *") long entry, @NativeType(value="bool") boolean checked) {
        long __functionAddress = Functions.SetTrayEntryChecked;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        JNI.invokePV(entry, checked, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTrayEntryChecked(@NativeType(value="SDL_TrayEntry *") long entry) {
        long __functionAddress = Functions.GetTrayEntryChecked;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        return JNI.invokePZ(entry, __functionAddress);
    }

    public static void SDL_SetTrayEntryEnabled(@NativeType(value="SDL_TrayEntry *") long entry, @NativeType(value="bool") boolean enabled) {
        long __functionAddress = Functions.SetTrayEntryEnabled;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        JNI.invokePV(entry, enabled, __functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTrayEntryEnabled(@NativeType(value="SDL_TrayEntry *") long entry) {
        long __functionAddress = Functions.GetTrayEntryEnabled;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        return JNI.invokePZ(entry, __functionAddress);
    }

    public static void nSDL_SetTrayEntryCallback(long entry, long callback, long userdata) {
        long __functionAddress = Functions.SetTrayEntryCallback;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        JNI.invokePPPV(entry, callback, userdata, __functionAddress);
    }

    public static void SDL_SetTrayEntryCallback(@NativeType(value="SDL_TrayEntry *") long entry, @NativeType(value="SDL_TrayCallback") @Nullable SDL_TrayCallbackI callback, @NativeType(value="void *") long userdata) {
        SDLTray.nSDL_SetTrayEntryCallback(entry, MemoryUtil.memAddressSafe(callback), userdata);
    }

    public static void SDL_ClickTrayEntry(@NativeType(value="SDL_TrayEntry *") long entry) {
        long __functionAddress = Functions.ClickTrayEntry;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        JNI.invokePV(entry, __functionAddress);
    }

    public static void SDL_DestroyTray(@NativeType(value="SDL_Tray *") long tray) {
        long __functionAddress = Functions.DestroyTray;
        if (Checks.CHECKS) {
            Checks.check(tray);
        }
        JNI.invokePV(tray, __functionAddress);
    }

    @NativeType(value="SDL_TrayMenu *")
    public static long SDL_GetTrayEntryParent(@NativeType(value="SDL_TrayEntry *") long entry) {
        long __functionAddress = Functions.GetTrayEntryParent;
        if (Checks.CHECKS) {
            Checks.check(entry);
        }
        return JNI.invokePP(entry, __functionAddress);
    }

    @NativeType(value="SDL_TrayEntry *")
    public static long SDL_GetTrayMenuParentEntry(@NativeType(value="SDL_TrayMenu *") long menu) {
        long __functionAddress = Functions.GetTrayMenuParentEntry;
        if (Checks.CHECKS) {
            Checks.check(menu);
        }
        return JNI.invokePP(menu, __functionAddress);
    }

    @NativeType(value="SDL_Tray *")
    public static long SDL_GetTrayMenuParentTray(@NativeType(value="SDL_TrayMenu *") long menu) {
        long __functionAddress = Functions.GetTrayMenuParentTray;
        if (Checks.CHECKS) {
            Checks.check(menu);
        }
        return JNI.invokePP(menu, __functionAddress);
    }

    public static void SDL_UpdateTrays() {
        long __functionAddress = Functions.UpdateTrays;
        JNI.invokeV(__functionAddress);
    }

    public static final class Functions {
        public static final long CreateTray = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateTray");
        public static final long SetTrayIcon = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetTrayIcon");
        public static final long SetTrayTooltip = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetTrayTooltip");
        public static final long CreateTrayMenu = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateTrayMenu");
        public static final long CreateTraySubmenu = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_CreateTraySubmenu");
        public static final long GetTrayMenu = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTrayMenu");
        public static final long GetTraySubmenu = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTraySubmenu");
        public static final long GetTrayEntries = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTrayEntries");
        public static final long RemoveTrayEntry = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_RemoveTrayEntry");
        public static final long InsertTrayEntryAt = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_InsertTrayEntryAt");
        public static final long SetTrayEntryLabel = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetTrayEntryLabel");
        public static final long GetTrayEntryLabel = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTrayEntryLabel");
        public static final long SetTrayEntryChecked = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetTrayEntryChecked");
        public static final long GetTrayEntryChecked = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTrayEntryChecked");
        public static final long SetTrayEntryEnabled = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetTrayEntryEnabled");
        public static final long GetTrayEntryEnabled = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTrayEntryEnabled");
        public static final long SetTrayEntryCallback = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_SetTrayEntryCallback");
        public static final long ClickTrayEntry = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_ClickTrayEntry");
        public static final long DestroyTray = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_DestroyTray");
        public static final long GetTrayEntryParent = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTrayEntryParent");
        public static final long GetTrayMenuParentEntry = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTrayMenuParentEntry");
        public static final long GetTrayMenuParentTray = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_GetTrayMenuParentTray");
        public static final long UpdateTrays = APIUtil.apiGetFunctionAddress(SDL.getLibrary(), "SDL_UpdateTrays");

        private Functions() {
        }
    }
}

