/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_FColor;
import org.lwjgl.sdl.SDL_GPUBlitRegion;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUBlitInfo
extends Struct<SDL_GPUBlitInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SOURCE;
    public static final int DESTINATION;
    public static final int LOAD_OP;
    public static final int CLEAR_COLOR;
    public static final int FLIP_MODE;
    public static final int FILTER;
    public static final int CYCLE;
    public static final int PADDING1;
    public static final int PADDING2;
    public static final int PADDING3;

    protected SDL_GPUBlitInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUBlitInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUBlitInfo(address, container);
    }

    public SDL_GPUBlitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUBlitInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public SDL_GPUBlitRegion source() {
        return SDL_GPUBlitInfo.nsource(this.address());
    }

    public SDL_GPUBlitRegion destination() {
        return SDL_GPUBlitInfo.ndestination(this.address());
    }

    @NativeType(value="SDL_GPULoadOp")
    public int load_op() {
        return SDL_GPUBlitInfo.nload_op(this.address());
    }

    public SDL_FColor clear_color() {
        return SDL_GPUBlitInfo.nclear_color(this.address());
    }

    @NativeType(value="SDL_FlipMode")
    public int flip_mode() {
        return SDL_GPUBlitInfo.nflip_mode(this.address());
    }

    @NativeType(value="SDL_GPUFilter")
    public int filter() {
        return SDL_GPUBlitInfo.nfilter(this.address());
    }

    @NativeType(value="bool")
    public boolean cycle() {
        return SDL_GPUBlitInfo.ncycle(this.address());
    }

    public SDL_GPUBlitInfo source(SDL_GPUBlitRegion value) {
        SDL_GPUBlitInfo.nsource(this.address(), value);
        return this;
    }

    public SDL_GPUBlitInfo source(Consumer<SDL_GPUBlitRegion> consumer) {
        consumer.accept(this.source());
        return this;
    }

    public SDL_GPUBlitInfo destination(SDL_GPUBlitRegion value) {
        SDL_GPUBlitInfo.ndestination(this.address(), value);
        return this;
    }

    public SDL_GPUBlitInfo destination(Consumer<SDL_GPUBlitRegion> consumer) {
        consumer.accept(this.destination());
        return this;
    }

    public SDL_GPUBlitInfo load_op(@NativeType(value="SDL_GPULoadOp") int value) {
        SDL_GPUBlitInfo.nload_op(this.address(), value);
        return this;
    }

    public SDL_GPUBlitInfo clear_color(SDL_FColor value) {
        SDL_GPUBlitInfo.nclear_color(this.address(), value);
        return this;
    }

    public SDL_GPUBlitInfo clear_color(Consumer<SDL_FColor> consumer) {
        consumer.accept(this.clear_color());
        return this;
    }

    public SDL_GPUBlitInfo flip_mode(@NativeType(value="SDL_FlipMode") int value) {
        SDL_GPUBlitInfo.nflip_mode(this.address(), value);
        return this;
    }

    public SDL_GPUBlitInfo filter(@NativeType(value="SDL_GPUFilter") int value) {
        SDL_GPUBlitInfo.nfilter(this.address(), value);
        return this;
    }

    public SDL_GPUBlitInfo cycle(@NativeType(value="bool") boolean value) {
        SDL_GPUBlitInfo.ncycle(this.address(), value);
        return this;
    }

    public SDL_GPUBlitInfo set(SDL_GPUBlitRegion source, SDL_GPUBlitRegion destination, int load_op, SDL_FColor clear_color, int flip_mode, int filter, boolean cycle) {
        this.source(source);
        this.destination(destination);
        this.load_op(load_op);
        this.clear_color(clear_color);
        this.flip_mode(flip_mode);
        this.filter(filter);
        this.cycle(cycle);
        return this;
    }

    public SDL_GPUBlitInfo set(SDL_GPUBlitInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUBlitInfo malloc() {
        return new SDL_GPUBlitInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUBlitInfo calloc() {
        return new SDL_GPUBlitInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUBlitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUBlitInfo(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUBlitInfo create(long address) {
        return new SDL_GPUBlitInfo(address, null);
    }

    public static @Nullable SDL_GPUBlitInfo createSafe(long address) {
        return address == 0L ? null : new SDL_GPUBlitInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUBlitInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUBlitInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUBlitInfo malloc(MemoryStack stack) {
        return new SDL_GPUBlitInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUBlitInfo calloc(MemoryStack stack) {
        return new SDL_GPUBlitInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static SDL_GPUBlitRegion nsource(long struct) {
        return SDL_GPUBlitRegion.create(struct + (long)SOURCE);
    }

    public static SDL_GPUBlitRegion ndestination(long struct) {
        return SDL_GPUBlitRegion.create(struct + (long)DESTINATION);
    }

    public static int nload_op(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOAD_OP);
    }

    public static SDL_FColor nclear_color(long struct) {
        return SDL_FColor.create(struct + (long)CLEAR_COLOR);
    }

    public static int nflip_mode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLIP_MODE);
    }

    public static int nfilter(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FILTER);
    }

    public static boolean ncycle(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CYCLE) != 0;
    }

    public static byte npadding1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING1);
    }

    public static byte npadding2(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING2);
    }

    public static byte npadding3(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING3);
    }

    public static void nsource(long struct, SDL_GPUBlitRegion value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SOURCE, SDL_GPUBlitRegion.SIZEOF);
    }

    public static void ndestination(long struct, SDL_GPUBlitRegion value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DESTINATION, SDL_GPUBlitRegion.SIZEOF);
    }

    public static void nload_op(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOAD_OP, value);
    }

    public static void nclear_color(long struct, SDL_FColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CLEAR_COLOR, SDL_FColor.SIZEOF);
    }

    public static void nflip_mode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLIP_MODE, value);
    }

    public static void nfilter(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FILTER, value);
    }

    public static void ncycle(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)CYCLE, value ? (byte)1 : 0);
    }

    public static void npadding1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING1, value);
    }

    public static void npadding2(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING2, value);
    }

    public static void npadding3(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING3, value);
    }

    public static void validate(long struct) {
        SDL_GPUBlitRegion.validate(struct + (long)SOURCE);
        SDL_GPUBlitRegion.validate(struct + (long)DESTINATION);
    }

    static {
        Struct.Layout layout = SDL_GPUBlitInfo.__struct(SDL_GPUBlitInfo.__member(SDL_GPUBlitRegion.SIZEOF, SDL_GPUBlitRegion.ALIGNOF), SDL_GPUBlitInfo.__member(SDL_GPUBlitRegion.SIZEOF, SDL_GPUBlitRegion.ALIGNOF), SDL_GPUBlitInfo.__member(4), SDL_GPUBlitInfo.__member(SDL_FColor.SIZEOF, SDL_FColor.ALIGNOF), SDL_GPUBlitInfo.__member(4), SDL_GPUBlitInfo.__member(4), SDL_GPUBlitInfo.__member(1), SDL_GPUBlitInfo.__member(1), SDL_GPUBlitInfo.__member(1), SDL_GPUBlitInfo.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SOURCE = layout.offsetof(0);
        DESTINATION = layout.offsetof(1);
        LOAD_OP = layout.offsetof(2);
        CLEAR_COLOR = layout.offsetof(3);
        FLIP_MODE = layout.offsetof(4);
        FILTER = layout.offsetof(5);
        CYCLE = layout.offsetof(6);
        PADDING1 = layout.offsetof(7);
        PADDING2 = layout.offsetof(8);
        PADDING3 = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUBlitInfo, Buffer>
    implements NativeResource {
        private static final SDL_GPUBlitInfo ELEMENT_FACTORY = SDL_GPUBlitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUBlitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public SDL_GPUBlitRegion source() {
            return SDL_GPUBlitInfo.nsource(this.address());
        }

        public SDL_GPUBlitRegion destination() {
            return SDL_GPUBlitInfo.ndestination(this.address());
        }

        @NativeType(value="SDL_GPULoadOp")
        public int load_op() {
            return SDL_GPUBlitInfo.nload_op(this.address());
        }

        public SDL_FColor clear_color() {
            return SDL_GPUBlitInfo.nclear_color(this.address());
        }

        @NativeType(value="SDL_FlipMode")
        public int flip_mode() {
            return SDL_GPUBlitInfo.nflip_mode(this.address());
        }

        @NativeType(value="SDL_GPUFilter")
        public int filter() {
            return SDL_GPUBlitInfo.nfilter(this.address());
        }

        @NativeType(value="bool")
        public boolean cycle() {
            return SDL_GPUBlitInfo.ncycle(this.address());
        }

        public Buffer source(SDL_GPUBlitRegion value) {
            SDL_GPUBlitInfo.nsource(this.address(), value);
            return this;
        }

        public Buffer source(Consumer<SDL_GPUBlitRegion> consumer) {
            consumer.accept(this.source());
            return this;
        }

        public Buffer destination(SDL_GPUBlitRegion value) {
            SDL_GPUBlitInfo.ndestination(this.address(), value);
            return this;
        }

        public Buffer destination(Consumer<SDL_GPUBlitRegion> consumer) {
            consumer.accept(this.destination());
            return this;
        }

        public Buffer load_op(@NativeType(value="SDL_GPULoadOp") int value) {
            SDL_GPUBlitInfo.nload_op(this.address(), value);
            return this;
        }

        public Buffer clear_color(SDL_FColor value) {
            SDL_GPUBlitInfo.nclear_color(this.address(), value);
            return this;
        }

        public Buffer clear_color(Consumer<SDL_FColor> consumer) {
            consumer.accept(this.clear_color());
            return this;
        }

        public Buffer flip_mode(@NativeType(value="SDL_FlipMode") int value) {
            SDL_GPUBlitInfo.nflip_mode(this.address(), value);
            return this;
        }

        public Buffer filter(@NativeType(value="SDL_GPUFilter") int value) {
            SDL_GPUBlitInfo.nfilter(this.address(), value);
            return this;
        }

        public Buffer cycle(@NativeType(value="bool") boolean value) {
            SDL_GPUBlitInfo.ncycle(this.address(), value);
            return this;
        }
    }
}

