/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUBufferBinding
extends Struct<SDL_GPUBufferBinding>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int OFFSET;

    protected SDL_GPUBufferBinding(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUBufferBinding create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUBufferBinding(address, container);
    }

    public SDL_GPUBufferBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUBufferBinding.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUBuffer *")
    public long buffer() {
        return SDL_GPUBufferBinding.nbuffer(this.address());
    }

    @NativeType(value="Uint32")
    public int offset() {
        return SDL_GPUBufferBinding.noffset(this.address());
    }

    public SDL_GPUBufferBinding buffer(@NativeType(value="SDL_GPUBuffer *") long value) {
        SDL_GPUBufferBinding.nbuffer(this.address(), value);
        return this;
    }

    public SDL_GPUBufferBinding offset(@NativeType(value="Uint32") int value) {
        SDL_GPUBufferBinding.noffset(this.address(), value);
        return this;
    }

    public SDL_GPUBufferBinding set(long buffer, int offset) {
        this.buffer(buffer);
        this.offset(offset);
        return this;
    }

    public SDL_GPUBufferBinding set(SDL_GPUBufferBinding src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUBufferBinding malloc() {
        return new SDL_GPUBufferBinding(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUBufferBinding calloc() {
        return new SDL_GPUBufferBinding(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUBufferBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUBufferBinding(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUBufferBinding create(long address) {
        return new SDL_GPUBufferBinding(address, null);
    }

    public static @Nullable SDL_GPUBufferBinding createSafe(long address) {
        return address == 0L ? null : new SDL_GPUBufferBinding(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUBufferBinding.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUBufferBinding.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUBufferBinding malloc(MemoryStack stack) {
        return new SDL_GPUBufferBinding(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUBufferBinding calloc(MemoryStack stack) {
        return new SDL_GPUBufferBinding(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BUFFER);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BUFFER, Checks.check(value));
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OFFSET, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BUFFER));
    }

    static {
        Struct.Layout layout = SDL_GPUBufferBinding.__struct(SDL_GPUBufferBinding.__member(POINTER_SIZE), SDL_GPUBufferBinding.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUBufferBinding, Buffer>
    implements NativeResource {
        private static final SDL_GPUBufferBinding ELEMENT_FACTORY = SDL_GPUBufferBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUBufferBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUBuffer *")
        public long buffer() {
            return SDL_GPUBufferBinding.nbuffer(this.address());
        }

        @NativeType(value="Uint32")
        public int offset() {
            return SDL_GPUBufferBinding.noffset(this.address());
        }

        public Buffer buffer(@NativeType(value="SDL_GPUBuffer *") long value) {
            SDL_GPUBufferBinding.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="Uint32") int value) {
            SDL_GPUBufferBinding.noffset(this.address(), value);
            return this;
        }
    }
}

