/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_GPUColorTargetBlendState;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUColorTargetDescription
extends Struct<SDL_GPUColorTargetDescription>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int BLEND_STATE;

    protected SDL_GPUColorTargetDescription(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUColorTargetDescription create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUColorTargetDescription(address, container);
    }

    public SDL_GPUColorTargetDescription(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUColorTargetDescription.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTextureFormat")
    public int format() {
        return SDL_GPUColorTargetDescription.nformat(this.address());
    }

    public SDL_GPUColorTargetBlendState blend_state() {
        return SDL_GPUColorTargetDescription.nblend_state(this.address());
    }

    public SDL_GPUColorTargetDescription format(@NativeType(value="SDL_GPUTextureFormat") int value) {
        SDL_GPUColorTargetDescription.nformat(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetDescription blend_state(SDL_GPUColorTargetBlendState value) {
        SDL_GPUColorTargetDescription.nblend_state(this.address(), value);
        return this;
    }

    public SDL_GPUColorTargetDescription blend_state(Consumer<SDL_GPUColorTargetBlendState> consumer) {
        consumer.accept(this.blend_state());
        return this;
    }

    public SDL_GPUColorTargetDescription set(int format, SDL_GPUColorTargetBlendState blend_state) {
        this.format(format);
        this.blend_state(blend_state);
        return this;
    }

    public SDL_GPUColorTargetDescription set(SDL_GPUColorTargetDescription src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUColorTargetDescription malloc() {
        return new SDL_GPUColorTargetDescription(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUColorTargetDescription calloc() {
        return new SDL_GPUColorTargetDescription(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUColorTargetDescription create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUColorTargetDescription(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUColorTargetDescription create(long address) {
        return new SDL_GPUColorTargetDescription(address, null);
    }

    public static @Nullable SDL_GPUColorTargetDescription createSafe(long address) {
        return address == 0L ? null : new SDL_GPUColorTargetDescription(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUColorTargetDescription.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUColorTargetDescription.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUColorTargetDescription malloc(MemoryStack stack) {
        return new SDL_GPUColorTargetDescription(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUColorTargetDescription calloc(MemoryStack stack) {
        return new SDL_GPUColorTargetDescription(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static SDL_GPUColorTargetBlendState nblend_state(long struct) {
        return SDL_GPUColorTargetBlendState.create(struct + (long)BLEND_STATE);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nblend_state(long struct, SDL_GPUColorTargetBlendState value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BLEND_STATE, SDL_GPUColorTargetBlendState.SIZEOF);
    }

    static {
        Struct.Layout layout = SDL_GPUColorTargetDescription.__struct(SDL_GPUColorTargetDescription.__member(4), SDL_GPUColorTargetDescription.__member(SDL_GPUColorTargetBlendState.SIZEOF, SDL_GPUColorTargetBlendState.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        BLEND_STATE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUColorTargetDescription, Buffer>
    implements NativeResource {
        private static final SDL_GPUColorTargetDescription ELEMENT_FACTORY = SDL_GPUColorTargetDescription.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUColorTargetDescription getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTextureFormat")
        public int format() {
            return SDL_GPUColorTargetDescription.nformat(this.address());
        }

        public SDL_GPUColorTargetBlendState blend_state() {
            return SDL_GPUColorTargetDescription.nblend_state(this.address());
        }

        public Buffer format(@NativeType(value="SDL_GPUTextureFormat") int value) {
            SDL_GPUColorTargetDescription.nformat(this.address(), value);
            return this;
        }

        public Buffer blend_state(SDL_GPUColorTargetBlendState value) {
            SDL_GPUColorTargetDescription.nblend_state(this.address(), value);
            return this;
        }

        public Buffer blend_state(Consumer<SDL_GPUColorTargetBlendState> consumer) {
            consumer.accept(this.blend_state());
            return this;
        }
    }
}

