/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_GPUStencilOpState;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUDepthStencilState
extends Struct<SDL_GPUDepthStencilState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COMPARE_OP;
    public static final int BACK_STENCIL_STATE;
    public static final int FRONT_STENCIL_STATE;
    public static final int COMPARE_MASK;
    public static final int WRITE_MASK;
    public static final int ENABLE_DEPTH_TEST;
    public static final int ENABLE_DEPTH_WRITE;
    public static final int ENABLE_STENCIL_TEST;
    public static final int PADDING1;
    public static final int PADDING2;
    public static final int PADDING3;

    protected SDL_GPUDepthStencilState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUDepthStencilState create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUDepthStencilState(address, container);
    }

    public SDL_GPUDepthStencilState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUDepthStencilState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUCompareOp")
    public int compare_op() {
        return SDL_GPUDepthStencilState.ncompare_op(this.address());
    }

    public SDL_GPUStencilOpState back_stencil_state() {
        return SDL_GPUDepthStencilState.nback_stencil_state(this.address());
    }

    public SDL_GPUStencilOpState front_stencil_state() {
        return SDL_GPUDepthStencilState.nfront_stencil_state(this.address());
    }

    @NativeType(value="Uint8")
    public byte compare_mask() {
        return SDL_GPUDepthStencilState.ncompare_mask(this.address());
    }

    @NativeType(value="Uint8")
    public byte write_mask() {
        return SDL_GPUDepthStencilState.nwrite_mask(this.address());
    }

    @NativeType(value="bool")
    public boolean enable_depth_test() {
        return SDL_GPUDepthStencilState.nenable_depth_test(this.address());
    }

    @NativeType(value="bool")
    public boolean enable_depth_write() {
        return SDL_GPUDepthStencilState.nenable_depth_write(this.address());
    }

    @NativeType(value="bool")
    public boolean enable_stencil_test() {
        return SDL_GPUDepthStencilState.nenable_stencil_test(this.address());
    }

    public SDL_GPUDepthStencilState compare_op(@NativeType(value="SDL_GPUCompareOp") int value) {
        SDL_GPUDepthStencilState.ncompare_op(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilState back_stencil_state(SDL_GPUStencilOpState value) {
        SDL_GPUDepthStencilState.nback_stencil_state(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilState back_stencil_state(Consumer<SDL_GPUStencilOpState> consumer) {
        consumer.accept(this.back_stencil_state());
        return this;
    }

    public SDL_GPUDepthStencilState front_stencil_state(SDL_GPUStencilOpState value) {
        SDL_GPUDepthStencilState.nfront_stencil_state(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilState front_stencil_state(Consumer<SDL_GPUStencilOpState> consumer) {
        consumer.accept(this.front_stencil_state());
        return this;
    }

    public SDL_GPUDepthStencilState compare_mask(@NativeType(value="Uint8") byte value) {
        SDL_GPUDepthStencilState.ncompare_mask(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilState write_mask(@NativeType(value="Uint8") byte value) {
        SDL_GPUDepthStencilState.nwrite_mask(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilState enable_depth_test(@NativeType(value="bool") boolean value) {
        SDL_GPUDepthStencilState.nenable_depth_test(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilState enable_depth_write(@NativeType(value="bool") boolean value) {
        SDL_GPUDepthStencilState.nenable_depth_write(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilState enable_stencil_test(@NativeType(value="bool") boolean value) {
        SDL_GPUDepthStencilState.nenable_stencil_test(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilState set(int compare_op, SDL_GPUStencilOpState back_stencil_state, SDL_GPUStencilOpState front_stencil_state, byte compare_mask, byte write_mask, boolean enable_depth_test, boolean enable_depth_write, boolean enable_stencil_test) {
        this.compare_op(compare_op);
        this.back_stencil_state(back_stencil_state);
        this.front_stencil_state(front_stencil_state);
        this.compare_mask(compare_mask);
        this.write_mask(write_mask);
        this.enable_depth_test(enable_depth_test);
        this.enable_depth_write(enable_depth_write);
        this.enable_stencil_test(enable_stencil_test);
        return this;
    }

    public SDL_GPUDepthStencilState set(SDL_GPUDepthStencilState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUDepthStencilState malloc() {
        return new SDL_GPUDepthStencilState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUDepthStencilState calloc() {
        return new SDL_GPUDepthStencilState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUDepthStencilState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUDepthStencilState(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUDepthStencilState create(long address) {
        return new SDL_GPUDepthStencilState(address, null);
    }

    public static @Nullable SDL_GPUDepthStencilState createSafe(long address) {
        return address == 0L ? null : new SDL_GPUDepthStencilState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUDepthStencilState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUDepthStencilState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUDepthStencilState malloc(MemoryStack stack) {
        return new SDL_GPUDepthStencilState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUDepthStencilState calloc(MemoryStack stack) {
        return new SDL_GPUDepthStencilState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncompare_op(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPARE_OP);
    }

    public static SDL_GPUStencilOpState nback_stencil_state(long struct) {
        return SDL_GPUStencilOpState.create(struct + (long)BACK_STENCIL_STATE);
    }

    public static SDL_GPUStencilOpState nfront_stencil_state(long struct) {
        return SDL_GPUStencilOpState.create(struct + (long)FRONT_STENCIL_STATE);
    }

    public static byte ncompare_mask(long struct) {
        return MemoryUtil.memGetByte(struct + (long)COMPARE_MASK);
    }

    public static byte nwrite_mask(long struct) {
        return MemoryUtil.memGetByte(struct + (long)WRITE_MASK);
    }

    public static boolean nenable_depth_test(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ENABLE_DEPTH_TEST) != 0;
    }

    public static boolean nenable_depth_write(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ENABLE_DEPTH_WRITE) != 0;
    }

    public static boolean nenable_stencil_test(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ENABLE_STENCIL_TEST) != 0;
    }

    public static byte npadding1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING1);
    }

    public static byte npadding2(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING2);
    }

    public static byte npadding3(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING3);
    }

    public static void ncompare_op(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPARE_OP, value);
    }

    public static void nback_stencil_state(long struct, SDL_GPUStencilOpState value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BACK_STENCIL_STATE, SDL_GPUStencilOpState.SIZEOF);
    }

    public static void nfront_stencil_state(long struct, SDL_GPUStencilOpState value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FRONT_STENCIL_STATE, SDL_GPUStencilOpState.SIZEOF);
    }

    public static void ncompare_mask(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)COMPARE_MASK, value);
    }

    public static void nwrite_mask(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)WRITE_MASK, value);
    }

    public static void nenable_depth_test(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)ENABLE_DEPTH_TEST, value ? (byte)1 : 0);
    }

    public static void nenable_depth_write(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)ENABLE_DEPTH_WRITE, value ? (byte)1 : 0);
    }

    public static void nenable_stencil_test(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)ENABLE_STENCIL_TEST, value ? (byte)1 : 0);
    }

    public static void npadding1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING1, value);
    }

    public static void npadding2(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING2, value);
    }

    public static void npadding3(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING3, value);
    }

    static {
        Struct.Layout layout = SDL_GPUDepthStencilState.__struct(SDL_GPUDepthStencilState.__member(4), SDL_GPUDepthStencilState.__member(SDL_GPUStencilOpState.SIZEOF, SDL_GPUStencilOpState.ALIGNOF), SDL_GPUDepthStencilState.__member(SDL_GPUStencilOpState.SIZEOF, SDL_GPUStencilOpState.ALIGNOF), SDL_GPUDepthStencilState.__member(1), SDL_GPUDepthStencilState.__member(1), SDL_GPUDepthStencilState.__member(1), SDL_GPUDepthStencilState.__member(1), SDL_GPUDepthStencilState.__member(1), SDL_GPUDepthStencilState.__member(1), SDL_GPUDepthStencilState.__member(1), SDL_GPUDepthStencilState.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COMPARE_OP = layout.offsetof(0);
        BACK_STENCIL_STATE = layout.offsetof(1);
        FRONT_STENCIL_STATE = layout.offsetof(2);
        COMPARE_MASK = layout.offsetof(3);
        WRITE_MASK = layout.offsetof(4);
        ENABLE_DEPTH_TEST = layout.offsetof(5);
        ENABLE_DEPTH_WRITE = layout.offsetof(6);
        ENABLE_STENCIL_TEST = layout.offsetof(7);
        PADDING1 = layout.offsetof(8);
        PADDING2 = layout.offsetof(9);
        PADDING3 = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUDepthStencilState, Buffer>
    implements NativeResource {
        private static final SDL_GPUDepthStencilState ELEMENT_FACTORY = SDL_GPUDepthStencilState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUDepthStencilState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUCompareOp")
        public int compare_op() {
            return SDL_GPUDepthStencilState.ncompare_op(this.address());
        }

        public SDL_GPUStencilOpState back_stencil_state() {
            return SDL_GPUDepthStencilState.nback_stencil_state(this.address());
        }

        public SDL_GPUStencilOpState front_stencil_state() {
            return SDL_GPUDepthStencilState.nfront_stencil_state(this.address());
        }

        @NativeType(value="Uint8")
        public byte compare_mask() {
            return SDL_GPUDepthStencilState.ncompare_mask(this.address());
        }

        @NativeType(value="Uint8")
        public byte write_mask() {
            return SDL_GPUDepthStencilState.nwrite_mask(this.address());
        }

        @NativeType(value="bool")
        public boolean enable_depth_test() {
            return SDL_GPUDepthStencilState.nenable_depth_test(this.address());
        }

        @NativeType(value="bool")
        public boolean enable_depth_write() {
            return SDL_GPUDepthStencilState.nenable_depth_write(this.address());
        }

        @NativeType(value="bool")
        public boolean enable_stencil_test() {
            return SDL_GPUDepthStencilState.nenable_stencil_test(this.address());
        }

        public Buffer compare_op(@NativeType(value="SDL_GPUCompareOp") int value) {
            SDL_GPUDepthStencilState.ncompare_op(this.address(), value);
            return this;
        }

        public Buffer back_stencil_state(SDL_GPUStencilOpState value) {
            SDL_GPUDepthStencilState.nback_stencil_state(this.address(), value);
            return this;
        }

        public Buffer back_stencil_state(Consumer<SDL_GPUStencilOpState> consumer) {
            consumer.accept(this.back_stencil_state());
            return this;
        }

        public Buffer front_stencil_state(SDL_GPUStencilOpState value) {
            SDL_GPUDepthStencilState.nfront_stencil_state(this.address(), value);
            return this;
        }

        public Buffer front_stencil_state(Consumer<SDL_GPUStencilOpState> consumer) {
            consumer.accept(this.front_stencil_state());
            return this;
        }

        public Buffer compare_mask(@NativeType(value="Uint8") byte value) {
            SDL_GPUDepthStencilState.ncompare_mask(this.address(), value);
            return this;
        }

        public Buffer write_mask(@NativeType(value="Uint8") byte value) {
            SDL_GPUDepthStencilState.nwrite_mask(this.address(), value);
            return this;
        }

        public Buffer enable_depth_test(@NativeType(value="bool") boolean value) {
            SDL_GPUDepthStencilState.nenable_depth_test(this.address(), value);
            return this;
        }

        public Buffer enable_depth_write(@NativeType(value="bool") boolean value) {
            SDL_GPUDepthStencilState.nenable_depth_write(this.address(), value);
            return this;
        }

        public Buffer enable_stencil_test(@NativeType(value="bool") boolean value) {
            SDL_GPUDepthStencilState.nenable_stencil_test(this.address(), value);
            return this;
        }
    }
}

