/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_GPUColorTargetDescription;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUGraphicsPipelineTargetInfo
extends Struct<SDL_GPUGraphicsPipelineTargetInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR_TARGET_DESCRIPTIONS;
    public static final int NUM_COLOR_TARGETS;
    public static final int DEPTH_STENCIL_FORMAT;
    public static final int HAS_DEPTH_STENCIL_TARGET;
    public static final int PADDING1;
    public static final int PADDING2;
    public static final int PADDING3;

    protected SDL_GPUGraphicsPipelineTargetInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUGraphicsPipelineTargetInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUGraphicsPipelineTargetInfo(address, container);
    }

    public SDL_GPUGraphicsPipelineTargetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUGraphicsPipelineTargetInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUColorTargetDescription const *")
    public @Nullable SDL_GPUColorTargetDescription.Buffer color_target_descriptions() {
        return SDL_GPUGraphicsPipelineTargetInfo.ncolor_target_descriptions(this.address());
    }

    @NativeType(value="Uint32")
    public int num_color_targets() {
        return SDL_GPUGraphicsPipelineTargetInfo.nnum_color_targets(this.address());
    }

    @NativeType(value="SDL_GPUTextureFormat")
    public int depth_stencil_format() {
        return SDL_GPUGraphicsPipelineTargetInfo.ndepth_stencil_format(this.address());
    }

    @NativeType(value="bool")
    public boolean has_depth_stencil_target() {
        return SDL_GPUGraphicsPipelineTargetInfo.nhas_depth_stencil_target(this.address());
    }

    public SDL_GPUGraphicsPipelineTargetInfo color_target_descriptions(@NativeType(value="SDL_GPUColorTargetDescription const *") @Nullable SDL_GPUColorTargetDescription.Buffer value) {
        SDL_GPUGraphicsPipelineTargetInfo.ncolor_target_descriptions(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineTargetInfo num_color_targets(@NativeType(value="Uint32") int value) {
        SDL_GPUGraphicsPipelineTargetInfo.nnum_color_targets(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineTargetInfo depth_stencil_format(@NativeType(value="SDL_GPUTextureFormat") int value) {
        SDL_GPUGraphicsPipelineTargetInfo.ndepth_stencil_format(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineTargetInfo has_depth_stencil_target(@NativeType(value="bool") boolean value) {
        SDL_GPUGraphicsPipelineTargetInfo.nhas_depth_stencil_target(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineTargetInfo set(@Nullable SDL_GPUColorTargetDescription.Buffer color_target_descriptions, int num_color_targets, int depth_stencil_format, boolean has_depth_stencil_target) {
        this.color_target_descriptions(color_target_descriptions);
        this.num_color_targets(num_color_targets);
        this.depth_stencil_format(depth_stencil_format);
        this.has_depth_stencil_target(has_depth_stencil_target);
        return this;
    }

    public SDL_GPUGraphicsPipelineTargetInfo set(SDL_GPUGraphicsPipelineTargetInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUGraphicsPipelineTargetInfo malloc() {
        return new SDL_GPUGraphicsPipelineTargetInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUGraphicsPipelineTargetInfo calloc() {
        return new SDL_GPUGraphicsPipelineTargetInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUGraphicsPipelineTargetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUGraphicsPipelineTargetInfo(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUGraphicsPipelineTargetInfo create(long address) {
        return new SDL_GPUGraphicsPipelineTargetInfo(address, null);
    }

    public static @Nullable SDL_GPUGraphicsPipelineTargetInfo createSafe(long address) {
        return address == 0L ? null : new SDL_GPUGraphicsPipelineTargetInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUGraphicsPipelineTargetInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUGraphicsPipelineTargetInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUGraphicsPipelineTargetInfo malloc(MemoryStack stack) {
        return new SDL_GPUGraphicsPipelineTargetInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUGraphicsPipelineTargetInfo calloc(MemoryStack stack) {
        return new SDL_GPUGraphicsPipelineTargetInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable SDL_GPUColorTargetDescription.Buffer ncolor_target_descriptions(long struct) {
        return SDL_GPUColorTargetDescription.createSafe(MemoryUtil.memGetAddress(struct + (long)COLOR_TARGET_DESCRIPTIONS), SDL_GPUGraphicsPipelineTargetInfo.nnum_color_targets(struct));
    }

    public static int nnum_color_targets(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_COLOR_TARGETS);
    }

    public static int ndepth_stencil_format(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTH_STENCIL_FORMAT);
    }

    public static boolean nhas_depth_stencil_target(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HAS_DEPTH_STENCIL_TARGET) != 0;
    }

    public static byte npadding1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING1);
    }

    public static byte npadding2(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING2);
    }

    public static byte npadding3(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING3);
    }

    public static void ncolor_target_descriptions(long struct, @Nullable SDL_GPUColorTargetDescription.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)COLOR_TARGET_DESCRIPTIONS, MemoryUtil.memAddressSafe(value));
        SDL_GPUGraphicsPipelineTargetInfo.nnum_color_targets(struct, value == null ? 0 : value.remaining());
    }

    public static void nnum_color_targets(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_COLOR_TARGETS, value);
    }

    public static void ndepth_stencil_format(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTH_STENCIL_FORMAT, value);
    }

    public static void nhas_depth_stencil_target(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)HAS_DEPTH_STENCIL_TARGET, value ? (byte)1 : 0);
    }

    public static void npadding1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING1, value);
    }

    public static void npadding2(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING2, value);
    }

    public static void npadding3(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING3, value);
    }

    static {
        Struct.Layout layout = SDL_GPUGraphicsPipelineTargetInfo.__struct(SDL_GPUGraphicsPipelineTargetInfo.__member(POINTER_SIZE), SDL_GPUGraphicsPipelineTargetInfo.__member(4), SDL_GPUGraphicsPipelineTargetInfo.__member(4), SDL_GPUGraphicsPipelineTargetInfo.__member(1), SDL_GPUGraphicsPipelineTargetInfo.__member(1), SDL_GPUGraphicsPipelineTargetInfo.__member(1), SDL_GPUGraphicsPipelineTargetInfo.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR_TARGET_DESCRIPTIONS = layout.offsetof(0);
        NUM_COLOR_TARGETS = layout.offsetof(1);
        DEPTH_STENCIL_FORMAT = layout.offsetof(2);
        HAS_DEPTH_STENCIL_TARGET = layout.offsetof(3);
        PADDING1 = layout.offsetof(4);
        PADDING2 = layout.offsetof(5);
        PADDING3 = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUGraphicsPipelineTargetInfo, Buffer>
    implements NativeResource {
        private static final SDL_GPUGraphicsPipelineTargetInfo ELEMENT_FACTORY = SDL_GPUGraphicsPipelineTargetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUGraphicsPipelineTargetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUColorTargetDescription const *")
        public @Nullable SDL_GPUColorTargetDescription.Buffer color_target_descriptions() {
            return SDL_GPUGraphicsPipelineTargetInfo.ncolor_target_descriptions(this.address());
        }

        @NativeType(value="Uint32")
        public int num_color_targets() {
            return SDL_GPUGraphicsPipelineTargetInfo.nnum_color_targets(this.address());
        }

        @NativeType(value="SDL_GPUTextureFormat")
        public int depth_stencil_format() {
            return SDL_GPUGraphicsPipelineTargetInfo.ndepth_stencil_format(this.address());
        }

        @NativeType(value="bool")
        public boolean has_depth_stencil_target() {
            return SDL_GPUGraphicsPipelineTargetInfo.nhas_depth_stencil_target(this.address());
        }

        public Buffer color_target_descriptions(@NativeType(value="SDL_GPUColorTargetDescription const *") @Nullable SDL_GPUColorTargetDescription.Buffer value) {
            SDL_GPUGraphicsPipelineTargetInfo.ncolor_target_descriptions(this.address(), value);
            return this;
        }

        public Buffer num_color_targets(@NativeType(value="Uint32") int value) {
            SDL_GPUGraphicsPipelineTargetInfo.nnum_color_targets(this.address(), value);
            return this;
        }

        public Buffer depth_stencil_format(@NativeType(value="SDL_GPUTextureFormat") int value) {
            SDL_GPUGraphicsPipelineTargetInfo.ndepth_stencil_format(this.address(), value);
            return this;
        }

        public Buffer has_depth_stencil_target(@NativeType(value="bool") boolean value) {
            SDL_GPUGraphicsPipelineTargetInfo.nhas_depth_stencil_target(this.address(), value);
            return this;
        }
    }
}

