/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUIndirectDrawCommand
extends Struct<SDL_GPUIndirectDrawCommand>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUM_VERTICES;
    public static final int NUM_INSTANCES;
    public static final int FIRST_VERTEX;
    public static final int FIRST_INSTANCE;

    protected SDL_GPUIndirectDrawCommand(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUIndirectDrawCommand create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUIndirectDrawCommand(address, container);
    }

    public SDL_GPUIndirectDrawCommand(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUIndirectDrawCommand.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint32")
    public int num_vertices() {
        return SDL_GPUIndirectDrawCommand.nnum_vertices(this.address());
    }

    @NativeType(value="Uint32")
    public int num_instances() {
        return SDL_GPUIndirectDrawCommand.nnum_instances(this.address());
    }

    @NativeType(value="Uint32")
    public int first_vertex() {
        return SDL_GPUIndirectDrawCommand.nfirst_vertex(this.address());
    }

    @NativeType(value="Uint32")
    public int first_instance() {
        return SDL_GPUIndirectDrawCommand.nfirst_instance(this.address());
    }

    public SDL_GPUIndirectDrawCommand num_vertices(@NativeType(value="Uint32") int value) {
        SDL_GPUIndirectDrawCommand.nnum_vertices(this.address(), value);
        return this;
    }

    public SDL_GPUIndirectDrawCommand num_instances(@NativeType(value="Uint32") int value) {
        SDL_GPUIndirectDrawCommand.nnum_instances(this.address(), value);
        return this;
    }

    public SDL_GPUIndirectDrawCommand first_vertex(@NativeType(value="Uint32") int value) {
        SDL_GPUIndirectDrawCommand.nfirst_vertex(this.address(), value);
        return this;
    }

    public SDL_GPUIndirectDrawCommand first_instance(@NativeType(value="Uint32") int value) {
        SDL_GPUIndirectDrawCommand.nfirst_instance(this.address(), value);
        return this;
    }

    public SDL_GPUIndirectDrawCommand set(int num_vertices, int num_instances, int first_vertex, int first_instance) {
        this.num_vertices(num_vertices);
        this.num_instances(num_instances);
        this.first_vertex(first_vertex);
        this.first_instance(first_instance);
        return this;
    }

    public SDL_GPUIndirectDrawCommand set(SDL_GPUIndirectDrawCommand src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUIndirectDrawCommand malloc() {
        return new SDL_GPUIndirectDrawCommand(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUIndirectDrawCommand calloc() {
        return new SDL_GPUIndirectDrawCommand(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUIndirectDrawCommand create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUIndirectDrawCommand(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUIndirectDrawCommand create(long address) {
        return new SDL_GPUIndirectDrawCommand(address, null);
    }

    public static @Nullable SDL_GPUIndirectDrawCommand createSafe(long address) {
        return address == 0L ? null : new SDL_GPUIndirectDrawCommand(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUIndirectDrawCommand.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUIndirectDrawCommand.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUIndirectDrawCommand malloc(MemoryStack stack) {
        return new SDL_GPUIndirectDrawCommand(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUIndirectDrawCommand calloc(MemoryStack stack) {
        return new SDL_GPUIndirectDrawCommand(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnum_vertices(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_VERTICES);
    }

    public static int nnum_instances(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_INSTANCES);
    }

    public static int nfirst_vertex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRST_VERTEX);
    }

    public static int nfirst_instance(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRST_INSTANCE);
    }

    public static void nnum_vertices(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_VERTICES, value);
    }

    public static void nnum_instances(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_INSTANCES, value);
    }

    public static void nfirst_vertex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRST_VERTEX, value);
    }

    public static void nfirst_instance(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRST_INSTANCE, value);
    }

    static {
        Struct.Layout layout = SDL_GPUIndirectDrawCommand.__struct(SDL_GPUIndirectDrawCommand.__member(4), SDL_GPUIndirectDrawCommand.__member(4), SDL_GPUIndirectDrawCommand.__member(4), SDL_GPUIndirectDrawCommand.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUM_VERTICES = layout.offsetof(0);
        NUM_INSTANCES = layout.offsetof(1);
        FIRST_VERTEX = layout.offsetof(2);
        FIRST_INSTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUIndirectDrawCommand, Buffer>
    implements NativeResource {
        private static final SDL_GPUIndirectDrawCommand ELEMENT_FACTORY = SDL_GPUIndirectDrawCommand.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUIndirectDrawCommand getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint32")
        public int num_vertices() {
            return SDL_GPUIndirectDrawCommand.nnum_vertices(this.address());
        }

        @NativeType(value="Uint32")
        public int num_instances() {
            return SDL_GPUIndirectDrawCommand.nnum_instances(this.address());
        }

        @NativeType(value="Uint32")
        public int first_vertex() {
            return SDL_GPUIndirectDrawCommand.nfirst_vertex(this.address());
        }

        @NativeType(value="Uint32")
        public int first_instance() {
            return SDL_GPUIndirectDrawCommand.nfirst_instance(this.address());
        }

        public Buffer num_vertices(@NativeType(value="Uint32") int value) {
            SDL_GPUIndirectDrawCommand.nnum_vertices(this.address(), value);
            return this;
        }

        public Buffer num_instances(@NativeType(value="Uint32") int value) {
            SDL_GPUIndirectDrawCommand.nnum_instances(this.address(), value);
            return this;
        }

        public Buffer first_vertex(@NativeType(value="Uint32") int value) {
            SDL_GPUIndirectDrawCommand.nfirst_vertex(this.address(), value);
            return this;
        }

        public Buffer first_instance(@NativeType(value="Uint32") int value) {
            SDL_GPUIndirectDrawCommand.nfirst_instance(this.address(), value);
            return this;
        }
    }
}

