/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUMultisampleState
extends Struct<SDL_GPUMultisampleState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLE_COUNT;
    public static final int SAMPLE_MASK;
    public static final int ENABLE_MASK;
    public static final int ENABLE_ALPHA_TO_COVERAGE;
    public static final int PADDING2;
    public static final int PADDING3;

    protected SDL_GPUMultisampleState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUMultisampleState create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUMultisampleState(address, container);
    }

    public SDL_GPUMultisampleState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUMultisampleState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUSampleCount")
    public int sample_count() {
        return SDL_GPUMultisampleState.nsample_count(this.address());
    }

    @NativeType(value="Uint32")
    public int sample_mask() {
        return SDL_GPUMultisampleState.nsample_mask(this.address());
    }

    @NativeType(value="bool")
    public boolean enable_mask() {
        return SDL_GPUMultisampleState.nenable_mask(this.address());
    }

    @NativeType(value="bool")
    public boolean enable_alpha_to_coverage() {
        return SDL_GPUMultisampleState.nenable_alpha_to_coverage(this.address());
    }

    public SDL_GPUMultisampleState sample_count(@NativeType(value="SDL_GPUSampleCount") int value) {
        SDL_GPUMultisampleState.nsample_count(this.address(), value);
        return this;
    }

    public SDL_GPUMultisampleState sample_mask(@NativeType(value="Uint32") int value) {
        SDL_GPUMultisampleState.nsample_mask(this.address(), value);
        return this;
    }

    public SDL_GPUMultisampleState enable_mask(@NativeType(value="bool") boolean value) {
        SDL_GPUMultisampleState.nenable_mask(this.address(), value);
        return this;
    }

    public SDL_GPUMultisampleState enable_alpha_to_coverage(@NativeType(value="bool") boolean value) {
        SDL_GPUMultisampleState.nenable_alpha_to_coverage(this.address(), value);
        return this;
    }

    public SDL_GPUMultisampleState set(int sample_count, int sample_mask, boolean enable_mask, boolean enable_alpha_to_coverage) {
        this.sample_count(sample_count);
        this.sample_mask(sample_mask);
        this.enable_mask(enable_mask);
        this.enable_alpha_to_coverage(enable_alpha_to_coverage);
        return this;
    }

    public SDL_GPUMultisampleState set(SDL_GPUMultisampleState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUMultisampleState malloc() {
        return new SDL_GPUMultisampleState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUMultisampleState calloc() {
        return new SDL_GPUMultisampleState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUMultisampleState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUMultisampleState(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUMultisampleState create(long address) {
        return new SDL_GPUMultisampleState(address, null);
    }

    public static @Nullable SDL_GPUMultisampleState createSafe(long address) {
        return address == 0L ? null : new SDL_GPUMultisampleState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUMultisampleState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUMultisampleState.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUMultisampleState malloc(MemoryStack stack) {
        return new SDL_GPUMultisampleState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUMultisampleState calloc(MemoryStack stack) {
        return new SDL_GPUMultisampleState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsample_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLE_COUNT);
    }

    public static int nsample_mask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLE_MASK);
    }

    public static boolean nenable_mask(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ENABLE_MASK) != 0;
    }

    public static boolean nenable_alpha_to_coverage(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ENABLE_ALPHA_TO_COVERAGE) != 0;
    }

    public static byte npadding2(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING2);
    }

    public static byte npadding3(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING3);
    }

    public static void nsample_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLE_COUNT, value);
    }

    public static void nsample_mask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLE_MASK, value);
    }

    public static void nenable_mask(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)ENABLE_MASK, value ? (byte)1 : 0);
    }

    public static void nenable_alpha_to_coverage(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)ENABLE_ALPHA_TO_COVERAGE, value ? (byte)1 : 0);
    }

    public static void npadding2(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING2, value);
    }

    public static void npadding3(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING3, value);
    }

    static {
        Struct.Layout layout = SDL_GPUMultisampleState.__struct(SDL_GPUMultisampleState.__member(4), SDL_GPUMultisampleState.__member(4), SDL_GPUMultisampleState.__member(1), SDL_GPUMultisampleState.__member(1), SDL_GPUMultisampleState.__member(1), SDL_GPUMultisampleState.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLE_COUNT = layout.offsetof(0);
        SAMPLE_MASK = layout.offsetof(1);
        ENABLE_MASK = layout.offsetof(2);
        ENABLE_ALPHA_TO_COVERAGE = layout.offsetof(3);
        PADDING2 = layout.offsetof(4);
        PADDING3 = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUMultisampleState, Buffer>
    implements NativeResource {
        private static final SDL_GPUMultisampleState ELEMENT_FACTORY = SDL_GPUMultisampleState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUMultisampleState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUSampleCount")
        public int sample_count() {
            return SDL_GPUMultisampleState.nsample_count(this.address());
        }

        @NativeType(value="Uint32")
        public int sample_mask() {
            return SDL_GPUMultisampleState.nsample_mask(this.address());
        }

        @NativeType(value="bool")
        public boolean enable_mask() {
            return SDL_GPUMultisampleState.nenable_mask(this.address());
        }

        @NativeType(value="bool")
        public boolean enable_alpha_to_coverage() {
            return SDL_GPUMultisampleState.nenable_alpha_to_coverage(this.address());
        }

        public Buffer sample_count(@NativeType(value="SDL_GPUSampleCount") int value) {
            SDL_GPUMultisampleState.nsample_count(this.address(), value);
            return this;
        }

        public Buffer sample_mask(@NativeType(value="Uint32") int value) {
            SDL_GPUMultisampleState.nsample_mask(this.address(), value);
            return this;
        }

        public Buffer enable_mask(@NativeType(value="bool") boolean value) {
            SDL_GPUMultisampleState.nenable_mask(this.address(), value);
            return this;
        }

        public Buffer enable_alpha_to_coverage(@NativeType(value="bool") boolean value) {
            SDL_GPUMultisampleState.nenable_alpha_to_coverage(this.address(), value);
            return this;
        }
    }
}

