/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUShaderCreateInfo
extends Struct<SDL_GPUShaderCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CODE_SIZE;
    public static final int CODE;
    public static final int ENTRYPOINT;
    public static final int FORMAT;
    public static final int STAGE;
    public static final int NUM_SAMPLERS;
    public static final int NUM_STORAGE_TEXTURES;
    public static final int NUM_STORAGE_BUFFERS;
    public static final int NUM_UNIFORM_BUFFERS;
    public static final int PROPS;

    protected SDL_GPUShaderCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUShaderCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUShaderCreateInfo(address, container);
    }

    public SDL_GPUShaderCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUShaderCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long code_size() {
        return SDL_GPUShaderCreateInfo.ncode_size(this.address());
    }

    @NativeType(value="Uint8 const *")
    public ByteBuffer code() {
        return SDL_GPUShaderCreateInfo.ncode(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer entrypoint() {
        return SDL_GPUShaderCreateInfo.nentrypoint(this.address());
    }

    @NativeType(value="char const *")
    public String entrypointString() {
        return SDL_GPUShaderCreateInfo.nentrypointString(this.address());
    }

    @NativeType(value="SDL_GPUShaderFormat")
    public int format() {
        return SDL_GPUShaderCreateInfo.nformat(this.address());
    }

    @NativeType(value="SDL_GPUShaderStage")
    public int stage() {
        return SDL_GPUShaderCreateInfo.nstage(this.address());
    }

    @NativeType(value="Uint32")
    public int num_samplers() {
        return SDL_GPUShaderCreateInfo.nnum_samplers(this.address());
    }

    @NativeType(value="Uint32")
    public int num_storage_textures() {
        return SDL_GPUShaderCreateInfo.nnum_storage_textures(this.address());
    }

    @NativeType(value="Uint32")
    public int num_storage_buffers() {
        return SDL_GPUShaderCreateInfo.nnum_storage_buffers(this.address());
    }

    @NativeType(value="Uint32")
    public int num_uniform_buffers() {
        return SDL_GPUShaderCreateInfo.nnum_uniform_buffers(this.address());
    }

    @NativeType(value="SDL_PropertiesID")
    public int props() {
        return SDL_GPUShaderCreateInfo.nprops(this.address());
    }

    public SDL_GPUShaderCreateInfo code(@NativeType(value="Uint8 const *") ByteBuffer value) {
        SDL_GPUShaderCreateInfo.ncode(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo entrypoint(@NativeType(value="char const *") ByteBuffer value) {
        SDL_GPUShaderCreateInfo.nentrypoint(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo format(@NativeType(value="SDL_GPUShaderFormat") int value) {
        SDL_GPUShaderCreateInfo.nformat(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo stage(@NativeType(value="SDL_GPUShaderStage") int value) {
        SDL_GPUShaderCreateInfo.nstage(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo num_samplers(@NativeType(value="Uint32") int value) {
        SDL_GPUShaderCreateInfo.nnum_samplers(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo num_storage_textures(@NativeType(value="Uint32") int value) {
        SDL_GPUShaderCreateInfo.nnum_storage_textures(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo num_storage_buffers(@NativeType(value="Uint32") int value) {
        SDL_GPUShaderCreateInfo.nnum_storage_buffers(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo num_uniform_buffers(@NativeType(value="Uint32") int value) {
        SDL_GPUShaderCreateInfo.nnum_uniform_buffers(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo props(@NativeType(value="SDL_PropertiesID") int value) {
        SDL_GPUShaderCreateInfo.nprops(this.address(), value);
        return this;
    }

    public SDL_GPUShaderCreateInfo set(ByteBuffer code, ByteBuffer entrypoint, int format, int stage, int num_samplers, int num_storage_textures, int num_storage_buffers, int num_uniform_buffers, int props) {
        this.code(code);
        this.entrypoint(entrypoint);
        this.format(format);
        this.stage(stage);
        this.num_samplers(num_samplers);
        this.num_storage_textures(num_storage_textures);
        this.num_storage_buffers(num_storage_buffers);
        this.num_uniform_buffers(num_uniform_buffers);
        this.props(props);
        return this;
    }

    public SDL_GPUShaderCreateInfo set(SDL_GPUShaderCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUShaderCreateInfo malloc() {
        return new SDL_GPUShaderCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUShaderCreateInfo calloc() {
        return new SDL_GPUShaderCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUShaderCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUShaderCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUShaderCreateInfo create(long address) {
        return new SDL_GPUShaderCreateInfo(address, null);
    }

    public static @Nullable SDL_GPUShaderCreateInfo createSafe(long address) {
        return address == 0L ? null : new SDL_GPUShaderCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUShaderCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUShaderCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUShaderCreateInfo malloc(MemoryStack stack) {
        return new SDL_GPUShaderCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUShaderCreateInfo calloc(MemoryStack stack) {
        return new SDL_GPUShaderCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncode_size(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CODE_SIZE);
    }

    public static ByteBuffer ncode(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)CODE), (int)SDL_GPUShaderCreateInfo.ncode_size(struct));
    }

    public static ByteBuffer nentrypoint(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)ENTRYPOINT));
    }

    public static String nentrypointString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)ENTRYPOINT));
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nstage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGE);
    }

    public static int nnum_samplers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_SAMPLERS);
    }

    public static int nnum_storage_textures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_STORAGE_TEXTURES);
    }

    public static int nnum_storage_buffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_STORAGE_BUFFERS);
    }

    public static int nnum_uniform_buffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_UNIFORM_BUFFERS);
    }

    public static int nprops(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROPS);
    }

    public static void ncode_size(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CODE_SIZE, value);
    }

    public static void ncode(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)CODE, MemoryUtil.memAddress(value));
        SDL_GPUShaderCreateInfo.ncode_size(struct, value.remaining());
    }

    public static void nentrypoint(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)ENTRYPOINT, MemoryUtil.memAddress(value));
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nstage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STAGE, value);
    }

    public static void nnum_samplers(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_SAMPLERS, value);
    }

    public static void nnum_storage_textures(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_STORAGE_TEXTURES, value);
    }

    public static void nnum_storage_buffers(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_STORAGE_BUFFERS, value);
    }

    public static void nnum_uniform_buffers(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_UNIFORM_BUFFERS, value);
    }

    public static void nprops(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PROPS, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CODE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ENTRYPOINT));
    }

    static {
        Struct.Layout layout = SDL_GPUShaderCreateInfo.__struct(SDL_GPUShaderCreateInfo.__member(POINTER_SIZE), SDL_GPUShaderCreateInfo.__member(POINTER_SIZE), SDL_GPUShaderCreateInfo.__member(POINTER_SIZE), SDL_GPUShaderCreateInfo.__member(4), SDL_GPUShaderCreateInfo.__member(4), SDL_GPUShaderCreateInfo.__member(4), SDL_GPUShaderCreateInfo.__member(4), SDL_GPUShaderCreateInfo.__member(4), SDL_GPUShaderCreateInfo.__member(4), SDL_GPUShaderCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CODE_SIZE = layout.offsetof(0);
        CODE = layout.offsetof(1);
        ENTRYPOINT = layout.offsetof(2);
        FORMAT = layout.offsetof(3);
        STAGE = layout.offsetof(4);
        NUM_SAMPLERS = layout.offsetof(5);
        NUM_STORAGE_TEXTURES = layout.offsetof(6);
        NUM_STORAGE_BUFFERS = layout.offsetof(7);
        NUM_UNIFORM_BUFFERS = layout.offsetof(8);
        PROPS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUShaderCreateInfo, Buffer>
    implements NativeResource {
        private static final SDL_GPUShaderCreateInfo ELEMENT_FACTORY = SDL_GPUShaderCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUShaderCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long code_size() {
            return SDL_GPUShaderCreateInfo.ncode_size(this.address());
        }

        @NativeType(value="Uint8 const *")
        public ByteBuffer code() {
            return SDL_GPUShaderCreateInfo.ncode(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer entrypoint() {
            return SDL_GPUShaderCreateInfo.nentrypoint(this.address());
        }

        @NativeType(value="char const *")
        public String entrypointString() {
            return SDL_GPUShaderCreateInfo.nentrypointString(this.address());
        }

        @NativeType(value="SDL_GPUShaderFormat")
        public int format() {
            return SDL_GPUShaderCreateInfo.nformat(this.address());
        }

        @NativeType(value="SDL_GPUShaderStage")
        public int stage() {
            return SDL_GPUShaderCreateInfo.nstage(this.address());
        }

        @NativeType(value="Uint32")
        public int num_samplers() {
            return SDL_GPUShaderCreateInfo.nnum_samplers(this.address());
        }

        @NativeType(value="Uint32")
        public int num_storage_textures() {
            return SDL_GPUShaderCreateInfo.nnum_storage_textures(this.address());
        }

        @NativeType(value="Uint32")
        public int num_storage_buffers() {
            return SDL_GPUShaderCreateInfo.nnum_storage_buffers(this.address());
        }

        @NativeType(value="Uint32")
        public int num_uniform_buffers() {
            return SDL_GPUShaderCreateInfo.nnum_uniform_buffers(this.address());
        }

        @NativeType(value="SDL_PropertiesID")
        public int props() {
            return SDL_GPUShaderCreateInfo.nprops(this.address());
        }

        public Buffer code(@NativeType(value="Uint8 const *") ByteBuffer value) {
            SDL_GPUShaderCreateInfo.ncode(this.address(), value);
            return this;
        }

        public Buffer entrypoint(@NativeType(value="char const *") ByteBuffer value) {
            SDL_GPUShaderCreateInfo.nentrypoint(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="SDL_GPUShaderFormat") int value) {
            SDL_GPUShaderCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer stage(@NativeType(value="SDL_GPUShaderStage") int value) {
            SDL_GPUShaderCreateInfo.nstage(this.address(), value);
            return this;
        }

        public Buffer num_samplers(@NativeType(value="Uint32") int value) {
            SDL_GPUShaderCreateInfo.nnum_samplers(this.address(), value);
            return this;
        }

        public Buffer num_storage_textures(@NativeType(value="Uint32") int value) {
            SDL_GPUShaderCreateInfo.nnum_storage_textures(this.address(), value);
            return this;
        }

        public Buffer num_storage_buffers(@NativeType(value="Uint32") int value) {
            SDL_GPUShaderCreateInfo.nnum_storage_buffers(this.address(), value);
            return this;
        }

        public Buffer num_uniform_buffers(@NativeType(value="Uint32") int value) {
            SDL_GPUShaderCreateInfo.nnum_uniform_buffers(this.address(), value);
            return this;
        }

        public Buffer props(@NativeType(value="SDL_PropertiesID") int value) {
            SDL_GPUShaderCreateInfo.nprops(this.address(), value);
            return this;
        }
    }
}

