/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUStorageBufferReadWriteBinding
extends Struct<SDL_GPUStorageBufferReadWriteBinding>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int CYCLE;
    public static final int PADDING1;
    public static final int PADDING2;
    public static final int PADDING3;

    protected SDL_GPUStorageBufferReadWriteBinding(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUStorageBufferReadWriteBinding create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUStorageBufferReadWriteBinding(address, container);
    }

    public SDL_GPUStorageBufferReadWriteBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUStorageBufferReadWriteBinding.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUBuffer *")
    public long buffer() {
        return SDL_GPUStorageBufferReadWriteBinding.nbuffer(this.address());
    }

    @NativeType(value="bool")
    public boolean cycle() {
        return SDL_GPUStorageBufferReadWriteBinding.ncycle(this.address());
    }

    public SDL_GPUStorageBufferReadWriteBinding buffer(@NativeType(value="SDL_GPUBuffer *") long value) {
        SDL_GPUStorageBufferReadWriteBinding.nbuffer(this.address(), value);
        return this;
    }

    public SDL_GPUStorageBufferReadWriteBinding cycle(@NativeType(value="bool") boolean value) {
        SDL_GPUStorageBufferReadWriteBinding.ncycle(this.address(), value);
        return this;
    }

    public SDL_GPUStorageBufferReadWriteBinding set(long buffer, boolean cycle) {
        this.buffer(buffer);
        this.cycle(cycle);
        return this;
    }

    public SDL_GPUStorageBufferReadWriteBinding set(SDL_GPUStorageBufferReadWriteBinding src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUStorageBufferReadWriteBinding malloc() {
        return new SDL_GPUStorageBufferReadWriteBinding(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUStorageBufferReadWriteBinding calloc() {
        return new SDL_GPUStorageBufferReadWriteBinding(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUStorageBufferReadWriteBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUStorageBufferReadWriteBinding(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUStorageBufferReadWriteBinding create(long address) {
        return new SDL_GPUStorageBufferReadWriteBinding(address, null);
    }

    public static @Nullable SDL_GPUStorageBufferReadWriteBinding createSafe(long address) {
        return address == 0L ? null : new SDL_GPUStorageBufferReadWriteBinding(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUStorageBufferReadWriteBinding.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUStorageBufferReadWriteBinding.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUStorageBufferReadWriteBinding malloc(MemoryStack stack) {
        return new SDL_GPUStorageBufferReadWriteBinding(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUStorageBufferReadWriteBinding calloc(MemoryStack stack) {
        return new SDL_GPUStorageBufferReadWriteBinding(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BUFFER);
    }

    public static boolean ncycle(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CYCLE) != 0;
    }

    public static byte npadding1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING1);
    }

    public static byte npadding2(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING2);
    }

    public static byte npadding3(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING3);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BUFFER, Checks.check(value));
    }

    public static void ncycle(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)CYCLE, value ? (byte)1 : 0);
    }

    public static void npadding1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING1, value);
    }

    public static void npadding2(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING2, value);
    }

    public static void npadding3(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING3, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)BUFFER));
    }

    static {
        Struct.Layout layout = SDL_GPUStorageBufferReadWriteBinding.__struct(SDL_GPUStorageBufferReadWriteBinding.__member(POINTER_SIZE), SDL_GPUStorageBufferReadWriteBinding.__member(1), SDL_GPUStorageBufferReadWriteBinding.__member(1), SDL_GPUStorageBufferReadWriteBinding.__member(1), SDL_GPUStorageBufferReadWriteBinding.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        CYCLE = layout.offsetof(1);
        PADDING1 = layout.offsetof(2);
        PADDING2 = layout.offsetof(3);
        PADDING3 = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUStorageBufferReadWriteBinding, Buffer>
    implements NativeResource {
        private static final SDL_GPUStorageBufferReadWriteBinding ELEMENT_FACTORY = SDL_GPUStorageBufferReadWriteBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUStorageBufferReadWriteBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUBuffer *")
        public long buffer() {
            return SDL_GPUStorageBufferReadWriteBinding.nbuffer(this.address());
        }

        @NativeType(value="bool")
        public boolean cycle() {
            return SDL_GPUStorageBufferReadWriteBinding.ncycle(this.address());
        }

        public Buffer buffer(@NativeType(value="SDL_GPUBuffer *") long value) {
            SDL_GPUStorageBufferReadWriteBinding.nbuffer(this.address(), value);
            return this;
        }

        public Buffer cycle(@NativeType(value="bool") boolean value) {
            SDL_GPUStorageBufferReadWriteBinding.ncycle(this.address(), value);
            return this;
        }
    }
}

