/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUStorageTextureReadWriteBinding
extends Struct<SDL_GPUStorageTextureReadWriteBinding>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURE;
    public static final int MIP_LEVEL;
    public static final int LAYER;
    public static final int CYCLE;
    public static final int PADDING1;
    public static final int PADDING2;
    public static final int PADDING3;

    protected SDL_GPUStorageTextureReadWriteBinding(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUStorageTextureReadWriteBinding create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUStorageTextureReadWriteBinding(address, container);
    }

    public SDL_GPUStorageTextureReadWriteBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUStorageTextureReadWriteBinding.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTexture *")
    public long texture() {
        return SDL_GPUStorageTextureReadWriteBinding.ntexture(this.address());
    }

    @NativeType(value="Uint32")
    public int mip_level() {
        return SDL_GPUStorageTextureReadWriteBinding.nmip_level(this.address());
    }

    @NativeType(value="Uint32")
    public int layer() {
        return SDL_GPUStorageTextureReadWriteBinding.nlayer(this.address());
    }

    @NativeType(value="bool")
    public boolean cycle() {
        return SDL_GPUStorageTextureReadWriteBinding.ncycle(this.address());
    }

    public SDL_GPUStorageTextureReadWriteBinding texture(@NativeType(value="SDL_GPUTexture *") long value) {
        SDL_GPUStorageTextureReadWriteBinding.ntexture(this.address(), value);
        return this;
    }

    public SDL_GPUStorageTextureReadWriteBinding mip_level(@NativeType(value="Uint32") int value) {
        SDL_GPUStorageTextureReadWriteBinding.nmip_level(this.address(), value);
        return this;
    }

    public SDL_GPUStorageTextureReadWriteBinding layer(@NativeType(value="Uint32") int value) {
        SDL_GPUStorageTextureReadWriteBinding.nlayer(this.address(), value);
        return this;
    }

    public SDL_GPUStorageTextureReadWriteBinding cycle(@NativeType(value="bool") boolean value) {
        SDL_GPUStorageTextureReadWriteBinding.ncycle(this.address(), value);
        return this;
    }

    public SDL_GPUStorageTextureReadWriteBinding set(long texture, int mip_level, int layer, boolean cycle) {
        this.texture(texture);
        this.mip_level(mip_level);
        this.layer(layer);
        this.cycle(cycle);
        return this;
    }

    public SDL_GPUStorageTextureReadWriteBinding set(SDL_GPUStorageTextureReadWriteBinding src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUStorageTextureReadWriteBinding malloc() {
        return new SDL_GPUStorageTextureReadWriteBinding(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUStorageTextureReadWriteBinding calloc() {
        return new SDL_GPUStorageTextureReadWriteBinding(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUStorageTextureReadWriteBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUStorageTextureReadWriteBinding(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUStorageTextureReadWriteBinding create(long address) {
        return new SDL_GPUStorageTextureReadWriteBinding(address, null);
    }

    public static @Nullable SDL_GPUStorageTextureReadWriteBinding createSafe(long address) {
        return address == 0L ? null : new SDL_GPUStorageTextureReadWriteBinding(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUStorageTextureReadWriteBinding.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUStorageTextureReadWriteBinding.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUStorageTextureReadWriteBinding malloc(MemoryStack stack) {
        return new SDL_GPUStorageTextureReadWriteBinding(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUStorageTextureReadWriteBinding calloc(MemoryStack stack) {
        return new SDL_GPUStorageTextureReadWriteBinding(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntexture(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TEXTURE);
    }

    public static int nmip_level(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MIP_LEVEL);
    }

    public static int nlayer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYER);
    }

    public static boolean ncycle(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CYCLE) != 0;
    }

    public static byte npadding1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING1);
    }

    public static byte npadding2(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING2);
    }

    public static byte npadding3(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PADDING3);
    }

    public static void ntexture(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)TEXTURE, Checks.check(value));
    }

    public static void nmip_level(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MIP_LEVEL, value);
    }

    public static void nlayer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYER, value);
    }

    public static void ncycle(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)CYCLE, value ? (byte)1 : 0);
    }

    public static void npadding1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING1, value);
    }

    public static void npadding2(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING2, value);
    }

    public static void npadding3(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PADDING3, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)TEXTURE));
    }

    static {
        Struct.Layout layout = SDL_GPUStorageTextureReadWriteBinding.__struct(SDL_GPUStorageTextureReadWriteBinding.__member(POINTER_SIZE), SDL_GPUStorageTextureReadWriteBinding.__member(4), SDL_GPUStorageTextureReadWriteBinding.__member(4), SDL_GPUStorageTextureReadWriteBinding.__member(1), SDL_GPUStorageTextureReadWriteBinding.__member(1), SDL_GPUStorageTextureReadWriteBinding.__member(1), SDL_GPUStorageTextureReadWriteBinding.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        MIP_LEVEL = layout.offsetof(1);
        LAYER = layout.offsetof(2);
        CYCLE = layout.offsetof(3);
        PADDING1 = layout.offsetof(4);
        PADDING2 = layout.offsetof(5);
        PADDING3 = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUStorageTextureReadWriteBinding, Buffer>
    implements NativeResource {
        private static final SDL_GPUStorageTextureReadWriteBinding ELEMENT_FACTORY = SDL_GPUStorageTextureReadWriteBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUStorageTextureReadWriteBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTexture *")
        public long texture() {
            return SDL_GPUStorageTextureReadWriteBinding.ntexture(this.address());
        }

        @NativeType(value="Uint32")
        public int mip_level() {
            return SDL_GPUStorageTextureReadWriteBinding.nmip_level(this.address());
        }

        @NativeType(value="Uint32")
        public int layer() {
            return SDL_GPUStorageTextureReadWriteBinding.nlayer(this.address());
        }

        @NativeType(value="bool")
        public boolean cycle() {
            return SDL_GPUStorageTextureReadWriteBinding.ncycle(this.address());
        }

        public Buffer texture(@NativeType(value="SDL_GPUTexture *") long value) {
            SDL_GPUStorageTextureReadWriteBinding.ntexture(this.address(), value);
            return this;
        }

        public Buffer mip_level(@NativeType(value="Uint32") int value) {
            SDL_GPUStorageTextureReadWriteBinding.nmip_level(this.address(), value);
            return this;
        }

        public Buffer layer(@NativeType(value="Uint32") int value) {
            SDL_GPUStorageTextureReadWriteBinding.nlayer(this.address(), value);
            return this;
        }

        public Buffer cycle(@NativeType(value="bool") boolean value) {
            SDL_GPUStorageTextureReadWriteBinding.ncycle(this.address(), value);
            return this;
        }
    }
}

