/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUTextureCreateInfo
extends Struct<SDL_GPUTextureCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FORMAT;
    public static final int USAGE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int LAYER_COUNT_OR_DEPTH;
    public static final int NUM_LEVELS;
    public static final int SAMPLE_COUNT;
    public static final int PROPS;

    protected SDL_GPUTextureCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUTextureCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUTextureCreateInfo(address, container);
    }

    public SDL_GPUTextureCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUTextureCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTextureType")
    public int type() {
        return SDL_GPUTextureCreateInfo.ntype(this.address());
    }

    @NativeType(value="SDL_GPUTextureFormat")
    public int format() {
        return SDL_GPUTextureCreateInfo.nformat(this.address());
    }

    @NativeType(value="SDL_GPUTextureUsageFlags")
    public int usage() {
        return SDL_GPUTextureCreateInfo.nusage(this.address());
    }

    @NativeType(value="Uint32")
    public int width() {
        return SDL_GPUTextureCreateInfo.nwidth(this.address());
    }

    @NativeType(value="Uint32")
    public int height() {
        return SDL_GPUTextureCreateInfo.nheight(this.address());
    }

    @NativeType(value="Uint32")
    public int layer_count_or_depth() {
        return SDL_GPUTextureCreateInfo.nlayer_count_or_depth(this.address());
    }

    @NativeType(value="Uint32")
    public int num_levels() {
        return SDL_GPUTextureCreateInfo.nnum_levels(this.address());
    }

    @NativeType(value="SDL_GPUSampleCount")
    public int sample_count() {
        return SDL_GPUTextureCreateInfo.nsample_count(this.address());
    }

    @NativeType(value="SDL_PropertiesID")
    public int props() {
        return SDL_GPUTextureCreateInfo.nprops(this.address());
    }

    public SDL_GPUTextureCreateInfo type(@NativeType(value="SDL_GPUTextureType") int value) {
        SDL_GPUTextureCreateInfo.ntype(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo format(@NativeType(value="SDL_GPUTextureFormat") int value) {
        SDL_GPUTextureCreateInfo.nformat(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo usage(@NativeType(value="SDL_GPUTextureUsageFlags") int value) {
        SDL_GPUTextureCreateInfo.nusage(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo width(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureCreateInfo.nwidth(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo height(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureCreateInfo.nheight(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo layer_count_or_depth(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureCreateInfo.nlayer_count_or_depth(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo num_levels(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureCreateInfo.nnum_levels(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo sample_count(@NativeType(value="SDL_GPUSampleCount") int value) {
        SDL_GPUTextureCreateInfo.nsample_count(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo props(@NativeType(value="SDL_PropertiesID") int value) {
        SDL_GPUTextureCreateInfo.nprops(this.address(), value);
        return this;
    }

    public SDL_GPUTextureCreateInfo set(int type, int format, int usage, int width, int height, int layer_count_or_depth, int num_levels, int sample_count, int props) {
        this.type(type);
        this.format(format);
        this.usage(usage);
        this.width(width);
        this.height(height);
        this.layer_count_or_depth(layer_count_or_depth);
        this.num_levels(num_levels);
        this.sample_count(sample_count);
        this.props(props);
        return this;
    }

    public SDL_GPUTextureCreateInfo set(SDL_GPUTextureCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUTextureCreateInfo malloc() {
        return new SDL_GPUTextureCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUTextureCreateInfo calloc() {
        return new SDL_GPUTextureCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUTextureCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUTextureCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUTextureCreateInfo create(long address) {
        return new SDL_GPUTextureCreateInfo(address, null);
    }

    public static @Nullable SDL_GPUTextureCreateInfo createSafe(long address) {
        return address == 0L ? null : new SDL_GPUTextureCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUTextureCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUTextureCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUTextureCreateInfo malloc(MemoryStack stack) {
        return new SDL_GPUTextureCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUTextureCreateInfo calloc(MemoryStack stack) {
        return new SDL_GPUTextureCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nusage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)USAGE);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nlayer_count_or_depth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYER_COUNT_OR_DEPTH);
    }

    public static int nnum_levels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_LEVELS);
    }

    public static int nsample_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLE_COUNT);
    }

    public static int nprops(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROPS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nusage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)USAGE, value);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nlayer_count_or_depth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYER_COUNT_OR_DEPTH, value);
    }

    public static void nnum_levels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_LEVELS, value);
    }

    public static void nsample_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLE_COUNT, value);
    }

    public static void nprops(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PROPS, value);
    }

    static {
        Struct.Layout layout = SDL_GPUTextureCreateInfo.__struct(SDL_GPUTextureCreateInfo.__member(4), SDL_GPUTextureCreateInfo.__member(4), SDL_GPUTextureCreateInfo.__member(4), SDL_GPUTextureCreateInfo.__member(4), SDL_GPUTextureCreateInfo.__member(4), SDL_GPUTextureCreateInfo.__member(4), SDL_GPUTextureCreateInfo.__member(4), SDL_GPUTextureCreateInfo.__member(4), SDL_GPUTextureCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        USAGE = layout.offsetof(2);
        WIDTH = layout.offsetof(3);
        HEIGHT = layout.offsetof(4);
        LAYER_COUNT_OR_DEPTH = layout.offsetof(5);
        NUM_LEVELS = layout.offsetof(6);
        SAMPLE_COUNT = layout.offsetof(7);
        PROPS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUTextureCreateInfo, Buffer>
    implements NativeResource {
        private static final SDL_GPUTextureCreateInfo ELEMENT_FACTORY = SDL_GPUTextureCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUTextureCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTextureType")
        public int type() {
            return SDL_GPUTextureCreateInfo.ntype(this.address());
        }

        @NativeType(value="SDL_GPUTextureFormat")
        public int format() {
            return SDL_GPUTextureCreateInfo.nformat(this.address());
        }

        @NativeType(value="SDL_GPUTextureUsageFlags")
        public int usage() {
            return SDL_GPUTextureCreateInfo.nusage(this.address());
        }

        @NativeType(value="Uint32")
        public int width() {
            return SDL_GPUTextureCreateInfo.nwidth(this.address());
        }

        @NativeType(value="Uint32")
        public int height() {
            return SDL_GPUTextureCreateInfo.nheight(this.address());
        }

        @NativeType(value="Uint32")
        public int layer_count_or_depth() {
            return SDL_GPUTextureCreateInfo.nlayer_count_or_depth(this.address());
        }

        @NativeType(value="Uint32")
        public int num_levels() {
            return SDL_GPUTextureCreateInfo.nnum_levels(this.address());
        }

        @NativeType(value="SDL_GPUSampleCount")
        public int sample_count() {
            return SDL_GPUTextureCreateInfo.nsample_count(this.address());
        }

        @NativeType(value="SDL_PropertiesID")
        public int props() {
            return SDL_GPUTextureCreateInfo.nprops(this.address());
        }

        public Buffer type(@NativeType(value="SDL_GPUTextureType") int value) {
            SDL_GPUTextureCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="SDL_GPUTextureFormat") int value) {
            SDL_GPUTextureCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="SDL_GPUTextureUsageFlags") int value) {
            SDL_GPUTextureCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureCreateInfo.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureCreateInfo.nheight(this.address(), value);
            return this;
        }

        public Buffer layer_count_or_depth(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureCreateInfo.nlayer_count_or_depth(this.address(), value);
            return this;
        }

        public Buffer num_levels(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureCreateInfo.nnum_levels(this.address(), value);
            return this;
        }

        public Buffer sample_count(@NativeType(value="SDL_GPUSampleCount") int value) {
            SDL_GPUTextureCreateInfo.nsample_count(this.address(), value);
            return this;
        }

        public Buffer props(@NativeType(value="SDL_PropertiesID") int value) {
            SDL_GPUTextureCreateInfo.nprops(this.address(), value);
            return this;
        }
    }
}

