/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUVulkanOptions
extends Struct<SDL_GPUVulkanOptions>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VULKAN_API_VERSION;
    public static final int FEATURE_LIST;
    public static final int VULKAN_10_PHYSICAL_DEVICE_FEATURES;
    public static final int DEVICE_EXTENSION_COUNT;
    public static final int DEVICE_EXTENSION_NAMES;
    public static final int INSTANCE_EXTENSION_COUNT;
    public static final int INSTANCE_EXTENSION_NAMES;

    protected SDL_GPUVulkanOptions(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_GPUVulkanOptions create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUVulkanOptions(address, container);
    }

    public SDL_GPUVulkanOptions(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_GPUVulkanOptions.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint32")
    public int vulkan_api_version() {
        return SDL_GPUVulkanOptions.nvulkan_api_version(this.address());
    }

    @NativeType(value="void *")
    public long feature_list() {
        return SDL_GPUVulkanOptions.nfeature_list(this.address());
    }

    @NativeType(value="void *")
    public long vulkan_10_physical_device_features() {
        return SDL_GPUVulkanOptions.nvulkan_10_physical_device_features(this.address());
    }

    @NativeType(value="Uint32")
    public int device_extension_count() {
        return SDL_GPUVulkanOptions.ndevice_extension_count(this.address());
    }

    @NativeType(value="char const **")
    public @Nullable PointerBuffer device_extension_names() {
        return SDL_GPUVulkanOptions.ndevice_extension_names(this.address());
    }

    @NativeType(value="Uint32")
    public int instance_extension_count() {
        return SDL_GPUVulkanOptions.ninstance_extension_count(this.address());
    }

    @NativeType(value="char const **")
    public @Nullable PointerBuffer instance_extension_names() {
        return SDL_GPUVulkanOptions.ninstance_extension_names(this.address());
    }

    public SDL_GPUVulkanOptions vulkan_api_version(@NativeType(value="Uint32") int value) {
        SDL_GPUVulkanOptions.nvulkan_api_version(this.address(), value);
        return this;
    }

    public SDL_GPUVulkanOptions feature_list(@NativeType(value="void *") long value) {
        SDL_GPUVulkanOptions.nfeature_list(this.address(), value);
        return this;
    }

    public SDL_GPUVulkanOptions vulkan_10_physical_device_features(@NativeType(value="void *") long value) {
        SDL_GPUVulkanOptions.nvulkan_10_physical_device_features(this.address(), value);
        return this;
    }

    public SDL_GPUVulkanOptions device_extension_count(@NativeType(value="Uint32") int value) {
        SDL_GPUVulkanOptions.ndevice_extension_count(this.address(), value);
        return this;
    }

    public SDL_GPUVulkanOptions device_extension_names(@NativeType(value="char const **") @Nullable PointerBuffer value) {
        SDL_GPUVulkanOptions.ndevice_extension_names(this.address(), value);
        return this;
    }

    public SDL_GPUVulkanOptions instance_extension_count(@NativeType(value="Uint32") int value) {
        SDL_GPUVulkanOptions.ninstance_extension_count(this.address(), value);
        return this;
    }

    public SDL_GPUVulkanOptions instance_extension_names(@NativeType(value="char const **") @Nullable PointerBuffer value) {
        SDL_GPUVulkanOptions.ninstance_extension_names(this.address(), value);
        return this;
    }

    public SDL_GPUVulkanOptions set(int vulkan_api_version, long feature_list, long vulkan_10_physical_device_features, int device_extension_count, @Nullable PointerBuffer device_extension_names, int instance_extension_count, @Nullable PointerBuffer instance_extension_names) {
        this.vulkan_api_version(vulkan_api_version);
        this.feature_list(feature_list);
        this.vulkan_10_physical_device_features(vulkan_10_physical_device_features);
        this.device_extension_count(device_extension_count);
        this.device_extension_names(device_extension_names);
        this.instance_extension_count(instance_extension_count);
        this.instance_extension_names(instance_extension_names);
        return this;
    }

    public SDL_GPUVulkanOptions set(SDL_GPUVulkanOptions src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_GPUVulkanOptions malloc() {
        return new SDL_GPUVulkanOptions(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_GPUVulkanOptions calloc() {
        return new SDL_GPUVulkanOptions(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_GPUVulkanOptions create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_GPUVulkanOptions(MemoryUtil.memAddress(container), container);
    }

    public static SDL_GPUVulkanOptions create(long address) {
        return new SDL_GPUVulkanOptions(address, null);
    }

    public static @Nullable SDL_GPUVulkanOptions createSafe(long address) {
        return address == 0L ? null : new SDL_GPUVulkanOptions(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_GPUVulkanOptions.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUVulkanOptions.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUVulkanOptions malloc(MemoryStack stack) {
        return new SDL_GPUVulkanOptions(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUVulkanOptions calloc(MemoryStack stack) {
        return new SDL_GPUVulkanOptions(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nvulkan_api_version(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VULKAN_API_VERSION);
    }

    public static long nfeature_list(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FEATURE_LIST);
    }

    public static long nvulkan_10_physical_device_features(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VULKAN_10_PHYSICAL_DEVICE_FEATURES);
    }

    public static int ndevice_extension_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICE_EXTENSION_COUNT);
    }

    public static @Nullable PointerBuffer ndevice_extension_names(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)DEVICE_EXTENSION_NAMES), SDL_GPUVulkanOptions.ndevice_extension_count(struct));
    }

    public static int ninstance_extension_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INSTANCE_EXTENSION_COUNT);
    }

    public static @Nullable PointerBuffer ninstance_extension_names(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)INSTANCE_EXTENSION_NAMES), SDL_GPUVulkanOptions.ninstance_extension_count(struct));
    }

    public static void nvulkan_api_version(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VULKAN_API_VERSION, value);
    }

    public static void nfeature_list(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)FEATURE_LIST, value);
    }

    public static void nvulkan_10_physical_device_features(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VULKAN_10_PHYSICAL_DEVICE_FEATURES, value);
    }

    public static void ndevice_extension_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEVICE_EXTENSION_COUNT, value);
    }

    public static void ndevice_extension_names(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DEVICE_EXTENSION_NAMES, MemoryUtil.memAddressSafe(value));
        SDL_GPUVulkanOptions.ndevice_extension_count(struct, value == null ? 0 : value.remaining());
    }

    public static void ninstance_extension_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INSTANCE_EXTENSION_COUNT, value);
    }

    public static void ninstance_extension_names(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INSTANCE_EXTENSION_NAMES, MemoryUtil.memAddressSafe(value));
        SDL_GPUVulkanOptions.ninstance_extension_count(struct, value == null ? 0 : value.remaining());
    }

    static {
        Struct.Layout layout = SDL_GPUVulkanOptions.__struct(SDL_GPUVulkanOptions.__member(4), SDL_GPUVulkanOptions.__member(POINTER_SIZE), SDL_GPUVulkanOptions.__member(POINTER_SIZE), SDL_GPUVulkanOptions.__member(4), SDL_GPUVulkanOptions.__member(POINTER_SIZE), SDL_GPUVulkanOptions.__member(4), SDL_GPUVulkanOptions.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VULKAN_API_VERSION = layout.offsetof(0);
        FEATURE_LIST = layout.offsetof(1);
        VULKAN_10_PHYSICAL_DEVICE_FEATURES = layout.offsetof(2);
        DEVICE_EXTENSION_COUNT = layout.offsetof(3);
        DEVICE_EXTENSION_NAMES = layout.offsetof(4);
        INSTANCE_EXTENSION_COUNT = layout.offsetof(5);
        INSTANCE_EXTENSION_NAMES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUVulkanOptions, Buffer>
    implements NativeResource {
        private static final SDL_GPUVulkanOptions ELEMENT_FACTORY = SDL_GPUVulkanOptions.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_GPUVulkanOptions getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint32")
        public int vulkan_api_version() {
            return SDL_GPUVulkanOptions.nvulkan_api_version(this.address());
        }

        @NativeType(value="void *")
        public long feature_list() {
            return SDL_GPUVulkanOptions.nfeature_list(this.address());
        }

        @NativeType(value="void *")
        public long vulkan_10_physical_device_features() {
            return SDL_GPUVulkanOptions.nvulkan_10_physical_device_features(this.address());
        }

        @NativeType(value="Uint32")
        public int device_extension_count() {
            return SDL_GPUVulkanOptions.ndevice_extension_count(this.address());
        }

        @NativeType(value="char const **")
        public @Nullable PointerBuffer device_extension_names() {
            return SDL_GPUVulkanOptions.ndevice_extension_names(this.address());
        }

        @NativeType(value="Uint32")
        public int instance_extension_count() {
            return SDL_GPUVulkanOptions.ninstance_extension_count(this.address());
        }

        @NativeType(value="char const **")
        public @Nullable PointerBuffer instance_extension_names() {
            return SDL_GPUVulkanOptions.ninstance_extension_names(this.address());
        }

        public Buffer vulkan_api_version(@NativeType(value="Uint32") int value) {
            SDL_GPUVulkanOptions.nvulkan_api_version(this.address(), value);
            return this;
        }

        public Buffer feature_list(@NativeType(value="void *") long value) {
            SDL_GPUVulkanOptions.nfeature_list(this.address(), value);
            return this;
        }

        public Buffer vulkan_10_physical_device_features(@NativeType(value="void *") long value) {
            SDL_GPUVulkanOptions.nvulkan_10_physical_device_features(this.address(), value);
            return this;
        }

        public Buffer device_extension_count(@NativeType(value="Uint32") int value) {
            SDL_GPUVulkanOptions.ndevice_extension_count(this.address(), value);
            return this;
        }

        public Buffer device_extension_names(@NativeType(value="char const **") @Nullable PointerBuffer value) {
            SDL_GPUVulkanOptions.ndevice_extension_names(this.address(), value);
            return this;
        }

        public Buffer instance_extension_count(@NativeType(value="Uint32") int value) {
            SDL_GPUVulkanOptions.ninstance_extension_count(this.address(), value);
            return this;
        }

        public Buffer instance_extension_names(@NativeType(value="char const **") @Nullable PointerBuffer value) {
            SDL_GPUVulkanOptions.ninstance_extension_names(this.address(), value);
            return this;
        }
    }
}

