/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_Color;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Palette
extends Struct<SDL_Palette>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NCOLORS;
    public static final int COLORS;
    public static final int VERSION;
    public static final int REFCOUNT;

    protected SDL_Palette(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_Palette create(long address, @Nullable ByteBuffer container) {
        return new SDL_Palette(address, container);
    }

    public SDL_Palette(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_Palette.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int ncolors() {
        return SDL_Palette.nncolors(this.address());
    }

    @NativeType(value="SDL_Color *")
    public SDL_Color.Buffer colors() {
        return SDL_Palette.ncolors(this.address());
    }

    public static SDL_Palette malloc() {
        return new SDL_Palette(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_Palette calloc() {
        return new SDL_Palette(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_Palette create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_Palette(MemoryUtil.memAddress(container), container);
    }

    public static SDL_Palette create(long address) {
        return new SDL_Palette(address, null);
    }

    public static @Nullable SDL_Palette createSafe(long address) {
        return address == 0L ? null : new SDL_Palette(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_Palette.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Palette.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Palette malloc(MemoryStack stack) {
        return new SDL_Palette(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Palette calloc(MemoryStack stack) {
        return new SDL_Palette(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nncolors(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NCOLORS);
    }

    public static SDL_Color.Buffer ncolors(long struct) {
        return SDL_Color.create(MemoryUtil.memGetAddress(struct + (long)COLORS), SDL_Palette.nncolors(struct));
    }

    public static int nversion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERSION);
    }

    public static int nrefcount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFCOUNT);
    }

    static {
        Struct.Layout layout = SDL_Palette.__struct(SDL_Palette.__member(4), SDL_Palette.__member(POINTER_SIZE), SDL_Palette.__member(4), SDL_Palette.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NCOLORS = layout.offsetof(0);
        COLORS = layout.offsetof(1);
        VERSION = layout.offsetof(2);
        REFCOUNT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_Palette, Buffer>
    implements NativeResource {
        private static final SDL_Palette ELEMENT_FACTORY = SDL_Palette.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_Palette getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int ncolors() {
            return SDL_Palette.nncolors(this.address());
        }

        @NativeType(value="SDL_Color *")
        public SDL_Color.Buffer colors() {
            return SDL_Palette.ncolors(this.address());
        }
    }
}

