/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Point
extends Struct<SDL_Point>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected SDL_Point(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SDL_Point create(long address, @Nullable ByteBuffer container) {
        return new SDL_Point(address, container);
    }

    public SDL_Point(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SDL_Point.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return SDL_Point.nx(this.address());
    }

    public int y() {
        return SDL_Point.ny(this.address());
    }

    public SDL_Point x(int value) {
        SDL_Point.nx(this.address(), value);
        return this;
    }

    public SDL_Point y(int value) {
        SDL_Point.ny(this.address(), value);
        return this;
    }

    public SDL_Point set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public SDL_Point set(SDL_Point src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SDL_Point malloc() {
        return new SDL_Point(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SDL_Point calloc() {
        return new SDL_Point(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SDL_Point create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SDL_Point(MemoryUtil.memAddress(container), container);
    }

    public static SDL_Point create(long address) {
        return new SDL_Point(address, null);
    }

    public static @Nullable SDL_Point createSafe(long address) {
        return address == 0L ? null : new SDL_Point(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SDL_Point.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Point.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Point malloc(MemoryStack stack) {
        return new SDL_Point(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Point calloc(MemoryStack stack) {
        return new SDL_Point(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = SDL_Point.__struct(SDL_Point.__member(4), SDL_Point.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SDL_Point, Buffer>
    implements NativeResource {
        private static final SDL_Point ELEMENT_FACTORY = SDL_Point.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SDL_Point getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int x() {
            return SDL_Point.nx(this.address());
        }

        public int y() {
            return SDL_Point.ny(this.address());
        }

        public Buffer x(int value) {
            SDL_Point.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            SDL_Point.ny(this.address(), value);
            return this;
        }
    }
}

