/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.ffm;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Consumer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.ffm.GroupArray;
import org.lwjgl.system.ffm.StructBinder;

public final class StructArray<T>
extends Record
implements GroupArray<StructLayout, T> {
    private final StructBinder<T> binder;
    private final MemorySegment segment;

    public StructArray(StructBinder<T> binder, MemorySegment segment) {
        this.binder = binder;
        this.segment = segment;
    }

    public long address() {
        return this.segment.address();
    }

    public T get(long index) {
        return (T)this.binder.getAtIndex(this.segment, index);
    }

    public StructArray<T> set(long index, T value) {
        this.binder.setAtIndex(this.segment, index, value);
        return this;
    }

    public <GA extends GroupArray<StructLayout, T>> StructArray<T> copy(long thisIndex, GA other, long otherIndex, long length) {
        if (Checks.DEBUG) {
            Objects.checkFromIndexSize(thisIndex, length, this.length());
            Objects.checkFromIndexSize(otherIndex, length, other.length());
        }
        for (long i = 0L; i < length; ++i) {
            this.binder.copy(this.binder.getAtIndex(this.segment, thisIndex + i), this.binder.getAtIndex(other.segment(), otherIndex + i));
        }
        return this;
    }

    public void clear(long fromIndex, long toIndex) {
        if (Checks.DEBUG) {
            Objects.checkFromToIndex(fromIndex, toIndex, this.length());
        }
        for (long i = fromIndex; i < toIndex; ++i) {
            this.binder.clear(this.binder.getAtIndex(this.segment, i));
        }
    }

    public StructArray<T> apply(long index, Consumer<T> consumer) {
        if (Checks.DEBUG) {
            Objects.checkIndex(index, this.length());
        }
        this.binder.applyAtIndex(this.segment, index, consumer);
        return this;
    }

    public StructArray<T> slice(long index) {
        return new StructArray(this.binder, this.segment.asSlice(index * this.binder.sizeof()));
    }

    public StructArray<T> slice(long index, long elementCount) {
        long sizeof = this.binder.sizeof();
        return new StructArray(this.binder, this.segment.asSlice(index * sizeof, elementCount * sizeof));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{StructArray.class, "binder;segment", "binder", "segment"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StructArray.class, "binder;segment", "binder", "segment"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StructArray.class, "binder;segment", "binder", "segment"}, this, o);
    }

    public StructBinder<T> binder() {
        return this.binder;
    }

    public MemorySegment segment() {
        return this.segment;
    }
}

