/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.ffm.mapping;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.ValueLayout;
import org.lwjgl.system.Platform;
import org.lwjgl.system.ffm.mapping.IntegerMappings;
import org.lwjgl.system.ffm.mapping.Mapping;

final class IntegerMappings {
    private static final boolean CLONG32 = ValueLayout.ADDRESS.byteSize() == 4L || Platform.get() == Platform.WINDOWS;

    private IntegerMappings() {
    }

    static Mapping.Byte create(ValueLayout.OfByte layout, boolean signed) {
        Mapping.Pointer p = new Mapping.Pointer((MemoryLayout)layout);
        return signed ? new ByteS(layout, p) : new ByteU(layout, p);
    }

    static Mapping.Char create(ValueLayout.OfChar layout) {
        return new Mapping.Char(layout, new Mapping.Pointer((MemoryLayout)layout));
    }

    static Mapping.Short create(ValueLayout.OfShort layout, boolean signed) {
        Mapping.Pointer p = new Mapping.Pointer((MemoryLayout)layout);
        return signed ? new ShortS(layout, p) : new ShortU(layout, p);
    }

    static Mapping.Int create(ValueLayout.OfInt layout, boolean signed) {
        Mapping.Pointer p = new Mapping.Pointer((MemoryLayout)layout);
        return signed ? new IntS(layout, p) : new IntU(layout, p);
    }

    static Mapping.Long create(ValueLayout.OfLong layout, boolean signed) {
        Mapping.Pointer p = new Mapping.Pointer((MemoryLayout)layout);
        return signed ? new LongS(layout, p) : new LongU(layout, p);
    }

    static Mapping.CLong createCLong(String name, boolean signed) {
        if (CLONG32) {
            ValueLayout.OfInt layout = ValueLayout.JAVA_INT.withName(name);
            Mapping.Pointer p = new Mapping.Pointer((MemoryLayout)layout);
            return signed ? new CLong32S(layout, p) : new CLong32U(layout, p);
        }
        ValueLayout.OfLong layout = ValueLayout.JAVA_LONG.withName(name);
        Mapping.Pointer p = new Mapping.Pointer((MemoryLayout)layout);
        return new CLong64Impl(layout, p, signed);
    }

    static Mapping.Size create(AddressLayout layout, boolean signed) {
        Mapping.Pointer p = new Mapping.Pointer((MemoryLayout)layout);
        return signed ? new SizeS(layout, p) : new SizeU(layout, p);
    }
}

