/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XErrorEvent
extends Struct<XErrorEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DISPLAY;
    public static final int RESOURCEID;
    public static final int SERIAL;
    public static final int ERROR_CODE;
    public static final int REQUEST_CODE;
    public static final int MINOR_CODE;

    protected XErrorEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XErrorEvent create(long address, @Nullable ByteBuffer container) {
        return new XErrorEvent(address, container);
    }

    public XErrorEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XErrorEvent.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XErrorEvent.ntype(this.address());
    }

    @NativeType(value="Display *")
    public long display() {
        return XErrorEvent.ndisplay(this.address());
    }

    @NativeType(value="XID")
    public long resourceid() {
        return XErrorEvent.nresourceid(this.address());
    }

    @NativeType(value="unsigned long")
    public long serial() {
        return XErrorEvent.nserial(this.address());
    }

    @NativeType(value="unsigned char")
    public byte error_code() {
        return XErrorEvent.nerror_code(this.address());
    }

    @NativeType(value="unsigned char")
    public byte request_code() {
        return XErrorEvent.nrequest_code(this.address());
    }

    @NativeType(value="unsigned char")
    public byte minor_code() {
        return XErrorEvent.nminor_code(this.address());
    }

    public XErrorEvent type(int value) {
        XErrorEvent.ntype(this.address(), value);
        return this;
    }

    public XErrorEvent display(@NativeType(value="Display *") long value) {
        XErrorEvent.ndisplay(this.address(), value);
        return this;
    }

    public XErrorEvent resourceid(@NativeType(value="XID") long value) {
        XErrorEvent.nresourceid(this.address(), value);
        return this;
    }

    public XErrorEvent serial(@NativeType(value="unsigned long") long value) {
        XErrorEvent.nserial(this.address(), value);
        return this;
    }

    public XErrorEvent error_code(@NativeType(value="unsigned char") byte value) {
        XErrorEvent.nerror_code(this.address(), value);
        return this;
    }

    public XErrorEvent request_code(@NativeType(value="unsigned char") byte value) {
        XErrorEvent.nrequest_code(this.address(), value);
        return this;
    }

    public XErrorEvent minor_code(@NativeType(value="unsigned char") byte value) {
        XErrorEvent.nminor_code(this.address(), value);
        return this;
    }

    public XErrorEvent set(int type, long display, long resourceid, long serial, byte error_code, byte request_code, byte minor_code) {
        this.type(type);
        this.display(display);
        this.resourceid(resourceid);
        this.serial(serial);
        this.error_code(error_code);
        this.request_code(request_code);
        this.minor_code(minor_code);
        return this;
    }

    public XErrorEvent set(XErrorEvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XErrorEvent malloc() {
        return new XErrorEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XErrorEvent calloc() {
        return new XErrorEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XErrorEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new XErrorEvent(MemoryUtil.memAddress(container), container);
    }

    public static XErrorEvent create(long address) {
        return new XErrorEvent(address, null);
    }

    public static @Nullable XErrorEvent createSafe(long address) {
        return address == 0L ? null : new XErrorEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XErrorEvent.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XErrorEvent.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XErrorEvent malloc(MemoryStack stack) {
        return new XErrorEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XErrorEvent calloc(MemoryStack stack) {
        return new XErrorEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DISPLAY);
    }

    public static long nresourceid(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)RESOURCEID);
    }

    public static long nserial(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)SERIAL);
    }

    public static byte nerror_code(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ERROR_CODE);
    }

    public static byte nrequest_code(long struct) {
        return MemoryUtil.memGetByte(struct + (long)REQUEST_CODE);
    }

    public static byte nminor_code(long struct) {
        return MemoryUtil.memGetByte(struct + (long)MINOR_CODE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void ndisplay(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DISPLAY, Checks.check(value));
    }

    public static void nresourceid(long struct, long value) {
        MemoryUtil.memPutCLong(struct + (long)RESOURCEID, value);
    }

    public static void nserial(long struct, long value) {
        MemoryUtil.memPutCLong(struct + (long)SERIAL, value);
    }

    public static void nerror_code(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)ERROR_CODE, value);
    }

    public static void nrequest_code(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)REQUEST_CODE, value);
    }

    public static void nminor_code(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)MINOR_CODE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DISPLAY));
    }

    static {
        Struct.Layout layout = XErrorEvent.__struct(XErrorEvent.__member(4), XErrorEvent.__member(POINTER_SIZE), XErrorEvent.__member(CLONG_SIZE), XErrorEvent.__member(CLONG_SIZE), XErrorEvent.__member(1), XErrorEvent.__member(1), XErrorEvent.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DISPLAY = layout.offsetof(1);
        RESOURCEID = layout.offsetof(2);
        SERIAL = layout.offsetof(3);
        ERROR_CODE = layout.offsetof(4);
        REQUEST_CODE = layout.offsetof(5);
        MINOR_CODE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XErrorEvent, Buffer>
    implements NativeResource {
        private static final XErrorEvent ELEMENT_FACTORY = XErrorEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XErrorEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int type() {
            return XErrorEvent.ntype(this.address());
        }

        @NativeType(value="Display *")
        public long display() {
            return XErrorEvent.ndisplay(this.address());
        }

        @NativeType(value="XID")
        public long resourceid() {
            return XErrorEvent.nresourceid(this.address());
        }

        @NativeType(value="unsigned long")
        public long serial() {
            return XErrorEvent.nserial(this.address());
        }

        @NativeType(value="unsigned char")
        public byte error_code() {
            return XErrorEvent.nerror_code(this.address());
        }

        @NativeType(value="unsigned char")
        public byte request_code() {
            return XErrorEvent.nrequest_code(this.address());
        }

        @NativeType(value="unsigned char")
        public byte minor_code() {
            return XErrorEvent.nminor_code(this.address());
        }

        public Buffer type(int value) {
            XErrorEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer display(@NativeType(value="Display *") long value) {
            XErrorEvent.ndisplay(this.address(), value);
            return this;
        }

        public Buffer resourceid(@NativeType(value="XID") long value) {
            XErrorEvent.nresourceid(this.address(), value);
            return this;
        }

        public Buffer serial(@NativeType(value="unsigned long") long value) {
            XErrorEvent.nserial(this.address(), value);
            return this;
        }

        public Buffer error_code(@NativeType(value="unsigned char") byte value) {
            XErrorEvent.nerror_code(this.address(), value);
            return this;
        }

        public Buffer request_code(@NativeType(value="unsigned char") byte value) {
            XErrorEvent.nrequest_code(this.address(), value);
            return this;
        }

        public Buffer minor_code(@NativeType(value="unsigned char") byte value) {
            XErrorEvent.nminor_code(this.address(), value);
            return this;
        }
    }
}

