/*
 * Decompiled with CFR 0.152.
 */
package rhino;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import rhino.Context;
import rhino.ContextFactory;
import rhino.InterfaceAdapter;
import rhino.Scriptable;

public abstract class VMBridge {
    private static final ThreadLocal<Object[]> contextLocal = new ThreadLocal();

    public static Object getThreadContextHelper() {
        Object[] storage = contextLocal.get();
        if (storage == null) {
            storage = new Object[1];
            contextLocal.set(storage);
        }
        return storage;
    }

    public static Context getContext(Object contextHelper) {
        Object[] storage = (Object[])contextHelper;
        return (Context)storage[0];
    }

    public static void setContext(Object contextHelper, Context cx) {
        Object[] storage = (Object[])contextHelper;
        storage[0] = cx;
    }

    public static boolean tryToMakeAccessible(AccessibleObject accessible) {
        if (accessible.isAccessible()) {
            return true;
        }
        try {
            accessible.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accessible.isAccessible();
    }

    public static Object getInterfaceProxyHelper(ContextFactory cf, Class<?>[] interfaces) {
        Constructor<?> c;
        ClassLoader loader = interfaces[0].getClassLoader();
        Class<?> cl = Proxy.getProxyClass(loader, interfaces);
        try {
            c = cl.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
        return c;
    }

    public static Object newInterfaceProxy(Object proxyHelper, ContextFactory cf, InterfaceAdapter adapter, Object target, Scriptable topScope) {
        Object proxy2;
        Constructor c = (Constructor)proxyHelper;
        InvocationHandler handler = (proxy, method, args) -> {
            if (method.getDeclaringClass() == Object.class) {
                String methodName = method.getName();
                if (methodName.equals("equals")) {
                    Object other = args[0];
                    return proxy == other;
                }
                if (methodName.equals("hashCode")) {
                    return target.hashCode();
                }
                if (methodName.equals("toString")) {
                    return "Proxy[" + target.toString() + "]";
                }
            }
            return adapter.invoke(cf, target, topScope, proxy, method, args);
        };
        try {
            proxy2 = c.newInstance(handler);
        }
        catch (InvocationTargetException ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
        return proxy2;
    }
}

