# CMS Made Simple (CMSMS) Unauthenticated Remote Code Execution (CVE-2019-9053/CVE-2021-26120)

[中文版本(Chinese version)](README.zh-cn.md)

CMS Made Simple (CMSMS) is a free, open source content management system to provide developers, programmers and site owners a web-based development and administration area.

Smarty before 3.1.39 allows code injection via an unexpected function name after a `{function name=` substring, CVE-2021-26120 was assigned to this issue.

CMS Made Simple version <= 2.2.15, a user that is authenticated with designer permissions can trigger a server side template injection, the CVE-2021-26120 mentioned above.

So, if the CMSMS version is prior to 2.2.9.1, unauthencated attacker is able to chain [CVE-2019-9053](https://github.com/vulhub/vulhub/tree/master/cmsms/CVE-2019-9053) and CVE-2021-26120 to execute arbitrary code in the server.

References:

- <https://srcincite.io/pocs/cve-2021-26120.py.txt>
- <https://www.exploit-db.com/exploits/46635>

## Vulnerable Environment

Execute following command to start a CMS Made Simple 2.2.9.1:

```
docker compose up -d
```

After the server is started, you should install the CMS at `http://your-ip/install.php`.

Following the install instructions to install the CMSMS, MySQL database address is `db`, database name is `cmsms`, username and password are both `root`.

![](1.png)

## Exploit

Use the [POC](poc.py) inside the <https://srcincite.io/pocs/cve-2021-26120.py.txt> to reset the administrator password and execute arbitrary commands:

```
python poc.py 127.0.0.1 / id
```

![](2.png)

As you can see, `id` command has been executed.
