# Django调试页面跨站脚本漏洞（CVE-2017-12794）

Django是一个高级的Python Web框架，支持快速开发和简洁实用的设计。

Django 1.11.5和1.10.8版本之前的调试错误页面中存在跨站脚本（XSS）漏洞。当启用DEBUG模式时，错误页面可能会通过未经转义的HTML错误消息暴露敏感信息。

该漏洞在数据库错误发生并且其详细信息显示在调试页面时触发。数据库的错误消息在模板渲染之前没有被正确转义。

参考链接：

- <https://www.djangoproject.com/weblog/2017/sep/05/security-releases/>
- <https://nvd.nist.gov/vuln/detail/CVE-2017-12794>
- <https://www.leavesongs.com/PENETRATION/django-debug-page-xss.html>

## 环境搭建

执行如下命令启动一个存在漏洞的Django服务器（Django版本为1.11.4）：

```
docker compose up -d
```

环境启动后，访问`http://your-ip:8000`即可看到Django默认首页。

## 漏洞复现

访问以下URL创建一个包含JavaScript代码的恶意用户名：

```
http://your-ip:8000/create_user/?username=<script>alert(1)</script>
```

第一次请求将成功创建用户。然后，再次访问相同的URL以触发数据库唯一约束错误。错误页面将在错误消息中包含未经转义的用户名：

![](1.png)

用户名中的JavaScript代码将在浏览器中执行，证实了XSS漏洞的存在。攻击者可以利用此漏洞在调试页面的上下文中执行任意JavaScript代码，可能导致会话劫持或其他客户端攻击。

有关此漏洞的详细原理，请参考这篇博客：<https://www.leavesongs.com/PENETRATION/django-debug-page-xss.html>
