import os
import sys


os.environ.setdefault("DJANGO_SETTINGS_MODULE", __name__)
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
DEBUG = True
SECRET_KEY = 'vulhub'
ALLOWED_HOSTS = ['*']
MIDDLEWARE = [
    'django.middleware.common.CommonMiddleware',
]

ROOT_URLCONF = 'vuln.urls'
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
        },
    },
    'loggers': {
        'django': {
            'handlers': ['console'],
            'level': os.getenv('DJANGO_LOG_LEVEL', 'WARNING'),
        },
    },
}
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'cve',
        'USER': 'root',
        'PASSWORD': 'mysql',
        'HOST': 'db',
        'PORT': '3306',
    }
}
INSTALLED_APPS = [
    'vuln'
]



from django.core.management import execute_from_command_line
execute_from_command_line(sys.argv)
