# Drupal Remote Code Execution by phar deserialization (CVE-2019-6339)

[中文版本(Chinese version)](README.zh-cn.md)

Drupal is a free and open-source web content management framework written in PHP.

A remote code execution vulnerability exists in Drupal 7.x before 7.62, Drupal 8.5.x before 8.5.9 and 8.6.x before 8.6.6. The vulnerability is caused by improper handling of PHAR deserialization in the file system service, which can lead to remote code execution.

References:

- <https://www.drupal.org/sa-core-2019-002>
- <https://www.zerodayinitiative.com/blog/2019/4/11/a-series-of-unfortunate-images-drupal-1-click-to-rce-exploit-chain-detailed>
- <https://paper.seebug.org/897/>

## Environment Setup

Execute the following command to start a vulnerable Drupal 8.5.0 server:

```
docker compose up -d
```

After the server is started, visit `http://your-ip:8080/` to access the Drupal installation page. Follow the default configuration steps to complete the installation. Since there is no MySQL environment, you can choose SQLite as the database.

## Vulnerability Reproduction

First, log in as an administrator and upload an avatar. The avatar image should be a specially crafted PoC file (you can refer to [thezdi/PoC](https://github.com/thezdi/PoC/tree/master/Drupal) for the PoC):

![1](1.png)

By default, Drupal stores uploaded images in the `/sites/default/files/pictures/<YYYY-MM>/` directory and keeps their original filenames. This information is important for exploiting the vulnerability.

Visit `http://127.0.0.1:8080/admin/config/media/file-system` and enter the path to the previously uploaded image in the "Temporary directory" field. For example:

```
phar://./sites/default/files/pictures/2019-06/blog-ZDI-CAN-7232-cat_0.jpg
```

Save the configuration to trigger the vulnerability. The successful exploitation will be confirmed by the execution of the malicious code:

![2](2.png)
